<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\About;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AboutController extends Controller
{
    public function index()
    {
        $about = About::first();
        return view('Admin.about', compact('about'));
    }

    public function update(Request $request)
    {
        $this->validate(\request(),
            [
                'title' => 'required',
                'details' => 'required',
                'year_of_experience' => 'required',
                'no_of_client' => 'required',
                'image' => 'nullable|mimes:png,jpg,jpeg,webp',
            ]);
        try {

            $about = About::first();
            $about->title = $request->title;
            $about->details = $request->details;
            $about->year_of_experience = $request->year_of_experience;
            $about->no_of_client = $request->no_of_client;
            $about->updated_by = Auth::user()->id;
            $about->ip_address = $request->ip();
            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $about->image = $this->imageUpload($request, 'image', 'uploads/about');
            }
            $about->update();
            session()->flash('success', 'Company About Update successfully!');
            return redirect()->back();
        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Company About Update failed');
        }
    }
}
