<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Company;
use Illuminate\Http\Request;

class CompanyProfileController extends Controller
{
    public function index()
    {
        $info = Company::first();
        return view('Admin.company_profile', compact('info'));
    }

    public function update(Request $request)
    {
        $this->validate(\request(),
            [
                'company_name' => 'required',
                'phone' => [
                    'required',
                    'regex:/^(?:01[3-9]\d{8})$/',
                ],
                'email' => 'required',
                'address' => 'required',
                'logo' => 'nullable|mimes:png,jpg,jpeg',
            ]);
        try {

            $info = Company::first();
            $info->company_name = $request->company_name;
            $info->phone = $request->phone;
            $info->email = $request->email;
            $info->address = $request->address;
            $info->map = $request->map;
            $info->facebook = $request->facebook;
            $info->youtube = $request->youtube;
            $info->instagram = $request->instagram;
            $info->twitter = $request->twitter;
            $info->linkdin = $request->linkdin;
            // Handle image uploads individually
            if ($request->hasFile('logo')) {
                $info->logo = $this->imageUpload($request, 'logo', 'uploads/company');
            }
            $info->update();
            session()->flash('success', 'Company Profile Update successfully!');
            return redirect()->back();
        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Company Profile Update failed');
        }
    }

}
