<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Offer;
use Illuminate\Http\Request;

class OfferController extends Controller
{

    public function index()
    {
        $offer = Offer::first();
        return view('Admin.offer', compact('offer'));
    }

    public function update(Request $request)
    {
        $this->validate(\request(),
            [
                'title_one' => 'required',
                'short_description_one' => 'required',
                'discount_one' => 'required',
                'image_one' => 'nullable|mimes:png,jpg,jpeg,webp',
                'title_two' => 'required',
                'short_description_two' => 'required',
                'discount_two' => 'required',
                'image_two' => 'nullable|mimes:png,jpg,jpeg,webp',

            ]);
        try {

            $offer = Offer::first();
            $offer->title_one = $request->title_one;
            $offer->short_description_one = $request->short_description_one;
            $offer->discount_one = $request->discount_one;
            $offer->title_two = $request->title_two;
            $offer->short_description_two = $request->short_description_two;
            $offer->discount_two = $request->discount_two;

           // Handle image uploads individually
           if ($request->hasFile('image_one')) {
            $offer->image_one = $this->imageUpload($request, 'image_one', 'uploads/offer');
        }
        if ($request->hasFile('image_two')) {
            $offer->image_two = $this->imageUpload($request, 'image_two', 'uploads/offer');
        }

            $offer->update();
            session()->flash('success', 'Offer Update successfully!');
            return redirect()->back();
        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Offer Update failed');
        }
    }
}
