<?php

namespace App\Http\Controllers\Admin;

use App\Models\Service;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ServiceHeading;
use Illuminate\Support\Facades\Auth;

class ServiceController extends Controller
{
    public function index()
    {

        $service = Service::latest()->get();
        return view('Admin.service.index', compact('service'));
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'title' => 'required|string|min:5|max:100',
            'icon' => 'required|mimetypes:image/png,image/jpg,image/jpeg,image/webp,image/svg+xml',
        ]);

        try {
            $service = new Service();
            $service->title = $request->title;
            $service->add_by = Auth::user()->id;
            $service->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('icon')) {
                $service->icon = $this->imageUpload($request, 'icon', 'uploads/service');
            }

            $service->save();
            return redirect()->route('service.index')->with('success', 'Service Created Successfully');

        } catch (\Throwable $th) {
              // throw $th;
            return redirect()->back()->with('error', 'Service creation failed');
        }
    }


    public function edit($id)
    {

        $service = Service::find($id);
        $services = Service::get();
        return view('Admin.service.edit', compact('service', 'services'));
    }

    public function update($id, Request $request)
    {

        $this->validate(\request(),
            [
                'title' => 'required|string|min:10|max:100',
                'icon' => 'nullable|mimetypes:image/png,image/jpg,image/jpeg,image/webp,image/svg+xml',

            ]);

        try {
            $service = Service::find($id);
            $service->title = $request->title;
            $service->updated_by = Auth::user()->id;
            $service->ip_address = $request->ip();
            // Handle image uploads individually
            if ($request->hasFile('icon')) {
                $service->icon = $this->imageUpload($request, 'icon', 'uploads/service');
            }

            $service->update();
            return redirect()->route('service.index')->with('success', ' Service  Update Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Service Update failed');
        }

    }

    public function delete($id)
    {

        try {
            $service = Service::find($id);
            if (file_exists($service->icon) && $service->icon != null) {
                unlink($service->icon);
            }
            $service->delete();
            return redirect()->route('service.index')->with('success', ' Service Deleted Successful');

        } catch (\Throwable $th) {
            //throw $th;
            return redirect()->back()->with('error', ' Service Deleted failed');
        }

    }



    public function serviceHeading()
    {
        $serviceHeading = ServiceHeading::first();
        return view('Admin.service_heading', compact('serviceHeading'));
    }

    public function serviceHeadingUpdate(Request $request)
    {
        $this->validate(\request(),
            [
                'title' => 'required',
                'short_description' => 'required',
                'image_one' => 'nullable|mimes:png,jpg,jpeg,webp',
                'image_two' => 'nullable|mimes:png,jpg,jpeg,webp',

            ]);
        try {

            $serviceHeading = ServiceHeading::first();
            $serviceHeading->title = $request->title;
            $serviceHeading->short_description = $request->short_description;

            $serviceHeading->updated_by = Auth::user()->id;
            $serviceHeading->ip_address = $request->ip();
           // Handle image uploads individually
           if ($request->hasFile('image_one')) {
            $serviceHeading->image_one = $this->imageUpload($request, 'image_one', 'uploads/service');
        }
        if ($request->hasFile('image_two')) {
            $serviceHeading->image_two = $this->imageUpload($request, 'image_two', 'uploads/service');
        }

            $serviceHeading->update();
            session()->flash('success', 'Service Heading Update successfully!');
            return redirect()->back();
        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Service Heading Update failed');
        }
    }

}
