<?php

namespace App\Http\Controllers\Admin;

use App\Models\Slider;
use Illuminate\Http\Request;
use App\Models\ServiceHeading;
use App\Http\Controllers\Controller;
use App\Models\SliderHeading;
use Illuminate\Support\Facades\Auth;

class SliderController extends Controller
{
    public function index()
    {

        $slider = Slider::latest()->get();
        return view('Admin.slider.index', compact('slider'));
    }

    public function store(Request $request)
    {

        $this->validate(\request(),
            [
                // 'title' => 'required|string|min:10|max:100',
                // 'short_description' => 'nullable|string|max:200',
                'image' => 'required|mimes:png,jpg,jpeg,webp',
            ]);
        try {
            $slider = new Slider;
            $slider->title = $request->title;
            $slider->short_description = $request->short_description;
            $slider->add_by = Auth::user()->id;
            $slider->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $slider->image = $this->imageUpload($request, 'image', 'uploads/slider');
            }

            $slider->save();
            return redirect()->route('slider.index')->with('success', 'Slider Created Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', 'Slider created  failed');
        }

    }

    public function edit($id)
    {

        $slider = Slider::find($id);
        $sliders = Slider::get();
        return view('Admin.slider.edit', compact('slider', 'sliders'));
    }

    public function update($id, Request $request)
    {

        $this->validate(\request(),
            [
                // 'title' => 'required|string|min:10|max:100',
                // 'short_description' => 'nullable|string|max:200',
                'image' => 'nullable|mimes:png,jpg,jpeg,webp',

            ]);

        try {
            $slider = Slider::find($id);
            // $slider->title = $request->title;
            // $slider->short_description = $request->short_description;
            $slider->updated_by = Auth::user()->id;
            $slider->ip_address = $request->ip();
            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $slider->image = $this->imageUpload($request, 'image', 'uploads/slider');
            }

            $slider->update();
            return redirect()->route('slider.index')->with('success', ' Slider  Update Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Slider Update failed');
        }

    }

    public function delete($id)
    {

        try {
            $slider = Slider::find($id);
            if (file_exists($slider->image) && $slider->image != null) {
                unlink($slider->image);
            }
            $slider->delete();
            return redirect()->route('slider.index')->with('success', ' Slider Deleted Successful');

        } catch (\Throwable $th) {
            //throw $th;
            return redirect()->back()->with('error', ' Slider Deleted failed');
        }

    }



    public function sliderHeading()
    {
        $sliderHeading = SliderHeading::first();
        return view('Admin.sliderHeading', compact('sliderHeading'));
    }

    public function sliderHeadingUpdate(Request $request)
    {
        $this->validate(\request(),
            [
                'title' => 'required',
                'short_description' => 'required',

            ]);
        try {

            $sliderHeading = SliderHeading::first();
            $sliderHeading->title = $request->title;
            $sliderHeading->short_description = $request->short_description;

            $sliderHeading->updated_by = Auth::user()->id;
            $sliderHeading->ip_address = $request->ip();
            $sliderHeading->update();
            session()->flash('success', 'Slider Heading Update successfully!');
            return redirect()->back();
        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Slider Heading Update failed');
        }
    }
}
