<?php

namespace App\Http\Controllers\Admin;

use App\Models\Speciality;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class SpecialityController extends Controller
{
    public function index()
    {

        $speciality = Speciality::latest()->get();
        return view('Admin.speciality.index', compact('speciality'));
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'title' => 'required|string|min:5|max:50',
            'short_description' => 'nullable|string|max:150',
            'icon' => 'required|mimetypes:image/png,image/jpg,image/jpeg,image/webp,image/svg+xml',
        ]);

        try {
            $speciality = new Speciality;
            $speciality->title = $request->title;
            $speciality->short_description = $request->short_description;
            $speciality->add_by = Auth::user()->id;
            $speciality->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('icon')) {
                $speciality->icon = $this->imageUpload($request, 'icon', 'uploads/speciality');
            }

            $speciality->save();
            return redirect()->route('speciality.index')->with('success', 'Speciality Created Successfully');

        } catch (\Throwable $th) {
              // throw $th;
            return redirect()->back()->with('error', 'Speciality creation failed');
        }
    }


    public function edit($id)
    {

        $speciality = Speciality::find($id);
        $specialities = Speciality::get();
        return view('Admin.speciality.edit', compact('speciality', 'specialities'));
    }

    public function update($id, Request $request)
    {

        $this->validate(\request(),
            [
                'title' => 'required|string|min:10|max:50',
                'short_description' => 'nullable|string|max:150',
                'icon' => 'nullable|mimetypes:image/png,image/jpg,image/jpeg,image/webp,image/svg+xml',

            ]);

        try {
            $speciality = Speciality::find($id);
            $speciality->title = $request->title;
            $speciality->short_description = $request->short_description;
            $speciality->updated_by = Auth::user()->id;
            $speciality->ip_address = $request->ip();
            // Handle image uploads individually
            if ($request->hasFile('icon')) {
                $speciality->icon = $this->imageUpload($request, 'icon', 'uploads/speciality');
            }

            $speciality->update();
            return redirect()->route('speciality.index')->with('success', ' Speciality  Update Successful');

        } catch (\Throwable $th) {
            throw $th;
            return redirect()->back()->with('error', ' Speciality Update failed');
        }

    }

    public function delete($id)
    {

        try {
            $speciality = Speciality::find($id);
            if (file_exists($speciality->icon) && $speciality->icon != null) {
                unlink($speciality->icon);
            }
            $speciality->delete();
            return redirect()->route('speciality.index')->with('success', ' Speciality Deleted Successful');

        } catch (\Throwable $th) {
            //throw $th;
            return redirect()->back()->with('error', ' Speciality Deleted failed');
        }

    }
}
