<?php

namespace App\Http\Controllers\Admin;

use App\Models\Team;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class TeamController extends Controller
{
    public function index()
    {

        $team = Team::latest()->get();
        return view('Admin.team.index', compact('team'));
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'name' => 'required',
            'designation' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'image' => 'required|mimetypes:image/png,image/jpg,image/jpeg,image/webp,image',
        ]);

        try {
            $team = new Team();
            $team->name = $request->name;
            $team->designation = $request->designation;
            $team->email = $request->email;
            $team->phone = $request->phone;
            $team->facebook = $request->facebook;
            $team->twitter = $request->twitter;
            $team->add_by = Auth::user()->id;
            $team->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $team->image = $this->imageUpload($request, 'image', 'uploads/team');
            }
            $team->save();
            return redirect()->route('team.index')->with('success', 'Team Created Successfully');

        } catch (\Throwable $th) {
              // throw $th;
            return redirect()->back()->with('error', 'Team creation failed');
        }
    }


    public function edit($id)
    {

        $team = Team::find($id);
        $teams = Team::get();
        return view('Admin.team.edit', compact('team', 'teams'));
    }

    public function update($id, Request $request)
    {

        $this->validate(\request(),
            [
                'name' => 'required',
                'designation' => 'required',
                'email' => 'required',
                'phone' => 'required',
                'image' => 'nullable|mimes:png,jpg,jpeg,webp',

            ]);

        try {
            $team = Team::find($id);
            $team->name = $request->name;
            $team->designation = $request->designation;
            $team->email = $request->email;
            $team->phone = $request->phone;
            $team->facebook = $request->facebook;
            $team->twitter = $request->twitter;
            $team->updated_by = Auth::user()->id;
            $team->ip_address = $request->ip();
            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $team->image = $this->imageUpload($request, 'image', 'uploads/team');
            }

            $team->update();
            return redirect()->route('team.index')->with('success', ' Team  Update Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Team Update failed');
        }

    }

    public function delete($id)
    {

        try {
            $team = Team::find($id);
            if (file_exists($team->icon) && $team->icon != null) {
                unlink($team->icon);
            }
            $team->delete();
            return redirect()->route('team.index')->with('success', ' Team Deleted Successful');

        } catch (\Throwable $th) {
            //throw $th;
            return redirect()->back()->with('error', ' Team Deleted failed');
        }

    }
}
