<?php

namespace App\Http\Controllers\Admin;

use App\Models\Testmonial;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class TestmonialsController extends Controller
{
    public function index()
    {

        $testimonial = Testmonial::latest()->get();
        return view('Admin.testimonial.index', compact('testimonial'));
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'name' => 'required',
            'designation' => 'required',
            'rating' => 'required|integer|between:1,5',
            'short_description' => 'required',
            'image' => 'required|mimetypes:image/png,image/jpg,image/jpeg,image/webp,image',
        ]);

        try {
            $testimonial = new Testmonial();
            $testimonial->name = $request->name;
            $testimonial->designation = $request->designation;
            $testimonial->rating = $request->rating;
            $testimonial->short_description = $request->short_description;
            $testimonial->add_by = Auth::user()->id;
            $testimonial->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $testimonial->image = $this->imageUpload($request, 'image', 'uploads/tesmonial');
            }
            $testimonial->save();
            return redirect()->route('testimonials.index')->with('success', 'Testimonial (Client Feedback) Created Successfully');

        } catch (\Throwable $th) {
              // throw $th;
            return redirect()->back()->with('error', 'Testimonial (Client Feedback) failed');
        }
    }


    public function edit($id)
    {

        $testimonial = Testmonial::find($id);
        $testimonials = Testmonial::get();
        return view('Admin.testimonial.edit', compact('testimonial', 'testimonials'));
    }

    public function update($id, Request $request)
    {

        $this->validate(\request(),
            [
                'name' => 'required',
                'designation' => 'required',
                'rating' => 'required|integer|between:1,5',
                'short_description' => 'required',
                'image' => 'nullable|mimetypes:image/png,image/jpg,image/jpeg,image/webp,image',

            ]);

        try {
            $testimonial = Testmonial::find($id);
            $testimonial->name = $request->name;
            $testimonial->designation = $request->designation;
            $testimonial->rating = $request->rating;
            $testimonial->short_description = $request->short_description;

            $testimonial->updated_by = Auth::user()->id;
            $testimonial->ip_address = $request->ip();
            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $testimonial->image = $this->imageUpload($request, 'image', 'uploads/testimonial');
            }

            $testimonial->update();
            return redirect()->route('testimonials.index')->with('success', ' Testimonial (Client Feedback) Update Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', 'Testimonial (Client Feedback) Update failed');
        }

    }

    public function delete($id)
    {

        try {
            $testimonial = Testmonial::find($id);
            if (file_exists($testimonial->image) && $testimonial->image != null) {
                unlink($testimonial->image);
            }
            $testimonial->delete();
            return redirect()->route('testimonials.index')->with('success', 'Testimonial (Client Feedback)  Deleted Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', 'Testimonial (Client Feedback)  Deleted failed');
        }

    }
}
