<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TourPackage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TourPackageController extends Controller
{
    public function index()
    {

        $tourPackage = TourPackage::latest()->get();
        return view('Admin.tourPackage.index', compact('tourPackage'));
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'title' => 'required',
            'location' => 'required',
            'duration' => 'required',
            'tour_type' => 'required',
            'group_size' => 'required',
            'language' => 'required',
            'overview' => 'required',
            'image_one' => 'required|mimes:png,jpg,jpeg,webp',
            'image_two' => 'required|mimes:png,jpg,jpeg,webp',
            'image_three' => 'required|mimes:png,jpg,jpeg,webp',
            'image_four' => 'required|mimes:png,jpg,jpeg,webp',

        ]);

        try {
            $tourPackage = new TourPackage();
            $tourPackage->title = $request->title;
            $tourPackage->location = $request->location;
            $tourPackage->duration = $request->duration;
            $tourPackage->tour_type = $request->tour_type;
            $tourPackage->group_size = $request->group_size;
            $tourPackage->language = $request->language;
            $tourPackage->map_url = $request->map_url;
            $tourPackage->overview = $request->overview;
            $tourPackage->long_description = $request->long_description;
            $tourPackage->add_by = Auth::user()->id;
            $tourPackage->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('image_one')) {
                $tourPackage->image_one = $this->imageUpload($request, 'image_one', 'uploads/tourPackage');
            }
            if ($request->hasFile('image_two')) {
                $tourPackage->image_two = $this->imageUpload($request, 'image_two', 'uploads/tourPackage');
            }
            if ($request->hasFile('image_three')) {
                $tourPackage->image_three = $this->imageUpload($request, 'image_three', 'uploads/tourPackage');
            }
            if ($request->hasFile('image_four')) {
                $tourPackage->image_four = $this->imageUpload($request, 'image_four', 'uploads/tourPackage');
            }
            $tourPackage->save();
            return redirect()->route('tourPackage.index')->with('success', 'Tour & Packages Created Successfully');

        } catch (\Throwable $th) {
            return $th->getMessage();
            return redirect()->back()->with('error', 'Tour & Packages Created failed');
        }
    }

    public function edit($id)
    {

        $tourPackage = TourPackage::find($id);
        $tourPackages = TourPackage::get();
        return view('Admin.tourPackage.edit', compact('tourPackage', 'tourPackages'));
    }

    public function update($id, Request $request)
    {

        $this->validate(\request(),
            [
                'title' => 'required',
                'location' => 'required',
                'duration' => 'required',
                'tour_type' => 'required',
                'group_size' => 'required',
                'language' => 'required',
                'overview' => 'required',
                'image_one' => 'nullable|mimes:png,jpg,jpeg,webp',
                'image_two' => 'nullable|mimes:png,jpg,jpeg,webp',
                'image_three' => 'nullable|mimes:png,jpg,jpeg,webp',
                'image_four' => 'nullable|mimes:png,jpg,jpeg,webp',

            ]);

        try {
            $tourPackage = TourPackage::find($id);
            $tourPackage->title = $request->title;
            $tourPackage->location = $request->location;
            $tourPackage->duration = $request->duration;
            $tourPackage->tour_type = $request->tour_type;
            $tourPackage->group_size = $request->group_size;
            $tourPackage->language = $request->language;
            $tourPackage->map_url = $request->map_url;
            $tourPackage->long_description = $request->long_description;
            $tourPackage->overview = $request->overview;
            $tourPackage->updated_by = Auth::user()->id;
            $tourPackage->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('image_one')) {
                $tourPackage->image_one = $this->imageUpload($request, 'image_one', 'uploads/tourPackage');
            }
            if ($request->hasFile('image_two')) {
                $tourPackage->image_two = $this->imageUpload($request, 'image_two', 'uploads/tourPackage');
            }
            if ($request->hasFile('image_three')) {
                $tourPackage->image_three = $this->imageUpload($request, 'image_three', 'uploads/tourPackage');
            }
            if ($request->hasFile('image_four')) {
                $tourPackage->image_four = $this->imageUpload($request, 'image_four', 'uploads/tourPackage');
            }
            $tourPackage->update();
            return redirect()->route('tourPackage.index')->with('success', ' Tour & Packages Update Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', 'Tour & Packages Update failed');
        }

    }

    public function delete($id)
    {
        try {
            // Find the TourPackage by ID
            $tourPackage = TourPackage::find($id);

            // Delete image 1
            if (file_exists($tourPackage->image_one) && $tourPackage->image_one != null) {
                unlink($tourPackage->image_one);
            }

            // Delete image 2
            if (file_exists($tourPackage->image_two) && $tourPackage->image_two != null) {
                unlink($tourPackage->image_two);
            }

            // Delete image 3
            if (file_exists($tourPackage->image_three) && $tourPackage->image_three != null) {
                unlink($tourPackage->image_three);
            }

            // Delete image 4
            if (file_exists($tourPackage->image_four) && $tourPackage->image_four != null) {
                unlink($tourPackage->image_four);
            }

            // Delete the TourPackage record
            $tourPackage->delete();
            return redirect()->route('tourPackage.index')->with('success', 'Tour & package  deleted successfully.');

        } catch (\Throwable $th) {
            // Catch any errors
            return redirect()->back()->with('error', 'Tour & package Deleted Fail.');
        }
    }

}
