<?php

namespace App\Http\Controllers\Admin;

use App\Models\Video;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class VideoController extends Controller
{
    public function index()
    {
        $video = Video::first();
        return view('Admin.video', compact('video'));
    }

    public function update(Request $request)
    {
        $this->validate(\request(),
            [
                'title' => 'required',
                'short_description' => 'required',
                'video_link' => 'required',
                'image' => 'nullable|mimes:png,jpg,jpeg,webp',

            ]);
        try {

            $video = Video::first();
            $video->title = $request->title;
            $video->short_description = $request->short_description;
            $video->video_link = $request->video_link;

            $video->updated_by = Auth::user()->id;
            $video->ip_address = $request->ip();
           // Handle image uploads individually
           if ($request->hasFile('image')) {
            $video->image = $this->imageUpload($request, 'image', 'uploads/video');
        }

            $video->update();
            session()->flash('success', 'Video  Update successfully!');
            return redirect()->back();
        } catch (\Throwable $th) {
            throw $th;
            return redirect()->back()->with('error', ' Video Update failed');
        }
    }
}
