<?php

namespace App\Http\Controllers;

use App\Models\Banner;
use Illuminate\Http\Request;

class BannerController extends Controller
{

    public function index()
    {
        $banner = Banner::first();
        return view('Admin.banner', compact('banner'));
    }

    public function update(Request $request)
    {
        $this->validate(\request(),
            [
                'about_banner' => 'nullable|mimes:png,jpg,jpeg,webp',
                'contact_banner' => 'nullable|mimes:png,jpg,jpeg,webp',
                'service_banner' => 'nullable|mimes:png,jpg,jpeg,webp',
                'tour_package_banner' => 'nullable|mimes:png,jpg,jpeg,webp',

            ]);
        try {

            $banner = Banner::first();

           // Handle image uploads individually
           if ($request->hasFile('about_banner')) {
            $banner->about_banner = $this->imageUpload($request, 'about_banner', 'uploads/banner');
        }
           if ($request->hasFile('contact_banner')) {
            $banner->contact_banner = $this->imageUpload($request, 'contact_banner', 'uploads/banner');
        }
           if ($request->hasFile('service_banner')) {
            $banner->service_banner = $this->imageUpload($request, 'service_banner', 'uploads/banner');
        }
           if ($request->hasFile('tour_package_banner')) {
            $banner->tour_package_banner = $this->imageUpload($request, 'tour_package_banner', 'uploads/banner');
        }


            $banner->update();
            session()->flash('success', 'Banner Update successfully!');
            return redirect()->back();
        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Banner Update failed');
        }
    }
}
