<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class BlogController extends Controller
{
    public function index(){

        $blog = Blog::latest()->paginate(8);
        return view('Admin.blog.index', compact('blog'));
    }


    // public function create(){

    //     return view('Admin.blog.create');
    // }


    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required|string|max:255',
            'category' => 'required|string|max:255',
            // 'description' => 'required|string',
            'date' => 'required|date',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
        ]);

        try {

            $slug = Str::slug($request->title);

            // Ensure the slug is unique
            $originalSlug = $slug;
            $i = 1;
            while (Blog::where('slug', $slug)->exists()) {
                $slug = $originalSlug . '-' . $i;
                $i++;
            }
            $blog = new Blog();
            $blog->title = $request->title;
            $blog->category = $request->category;
            $blog->description = $request->description;
            $blog->slug = $slug;
            $blog->date = $request->date;
            $blog->added_by = Auth::user()->id;
            // $blog->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $blog->image = $this->imageUpload($request, 'image', 'uploads/blog');
            }
            $blog->save();
            return redirect()->route('blog.index')->with('success', 'Blog Created Successfully');

        } catch (\Throwable $th) {
              throw $th;
            return redirect()->back()->with('error', 'Blog creation failed');
        }
    }

    public function edit($id){

        $blog = Blog::find($id);
        $blogs = Blog::get();
        return view('Admin.blog.edit', compact('blog','blogs'));
    }


    public function update($id, Request $request){

        $this->validate($request, [
            'title' => 'required|string|max:255',
            'category' => 'required|string|max:255',
            // 'description' => 'required|string',
            'date' => 'required|date',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
        ]);


        try {
            $slug = Str::slug($request->title);

            // Ensure the slug is unique
            $originalSlug = $slug;
            $i = 1;
            while (Blog::where('slug', $slug)->exists()) {
                $slug = $originalSlug . '-' . $i;
                $i++;
            }
            $blog = Blog::find($id);
            $blog->title = $request->title;
            $blog->category = $request->category;
            $blog->description = $request->description;
            $blog->slug = $slug;
            $blog->date = $request->date;
            // $blog->updated_by = Auth::user()->id;

             // Handle image uploads individually
            if ($request->hasFile('image')) {
                $blog->image = $this->imageUpload($request, 'image', 'uploads/blog');
            }

            $blog->update();
            return redirect()->route('blog.index')->with('success', ' Blog  Update Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Blog Update failed');
        }

    }



    public function delete($id){

        try {
            $blog = Blog::find($id);
            if (file_exists($blog->image) && $blog->image != null) {
                unlink($blog->image);
            }
            $blog->delete();
            return redirect()->route('blog.index')->with('success', 'Deleted Successful');

        } catch (\Throwable $th) {
            //throw $th;
            return redirect()->back()->with('error', 'Deleted failed');
        }
    }
}
