<?php

namespace App\Http\Controllers;

use App\Models\Booking;
use App\Models\Newsletter;
use Illuminate\Http\Request;

class BookingController extends Controller
{
   public function booking(Request $request){

    $this->validate($request, [
        'name' => 'required',
        'destination' => 'required',
        'start_date' => 'required',
    ]);

    try {
        $booking = new Booking();
        $booking->name = $request->name;
        $booking->destination = $request->destination;
        $booking->start_date = $request->start_date;
        $booking->end_date = $request->end_date;
        $booking->phone = $request->phone;
        $booking->email = $request->email;
        $booking->adult = $request->adult;
        $booking->child = $request->child;
        $booking->address = $request->address;
        $booking->message = $request->message;
        $booking->ip_address = $request->ip();

        $booking->save();
        return redirect()->back()->with('success', 'Booking Submission Successfull ');

    } catch (\Throwable $th) {
          // throw $th;
        return redirect()->back()->with('error', 'Booking Submission failed');
    }

   }

   public function bookingList(){

    $bookingList = Booking::get();
    return view('Admin.booking',compact('bookingList'));
   }


   public function delete($id){

     try {
             $booking = Booking::findOrFail($id);
             $booking->delete();
             return redirect()->back()->with('success', 'Tour Booking soft deleted successfully.');

         } catch (\Throwable $th) {
             // Redirect with error message in case of failure
             return redirect()->back()->with('error', 'Tour Booking soft delete failed.');
         }
   }



   public function newsletter(Request $request){

    $this->validate($request, [
        'email' => 'required',
    ]);


    try {
        $newsletter = new Newsletter();
        $newsletter->email = $request->email;
        $newsletter->ip_address = $request->ip();

        $newsletter->save();
        return redirect()->back()->with('success', 'News Letter  Submission Successfull ');

    } catch (\Throwable $th) {
          throw $th;
        return redirect()->back()->with('error', 'News Letter Submission failed');
    }


   }

   public function newsLetterList(){

    $newsletter = Newsletter::get();
    return view('Admin.newsletter',compact('newsletter'));
   }


   public function newLetterdelete($id){

     try {
             $newsletter = NewsLetter::findOrFail($id);
             $newsletter->delete();
             return redirect()->back()->with('success', 'News Letter deleted successfully.');

         } catch (\Throwable $th) {
             // Redirect with error message in case of failure
             return redirect()->back()->with('error', 'News Letter delete failed.');
         }
   }


}
