<?php

namespace App\Http\Controllers;

use App\Models\Video;
use App\Models\Gallery;
use App\Models\GalleryVideo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class GalleryController extends Controller
{

    public function index()
    {

        $gallery = Gallery::latest()->get();
        return view('Admin.gallery.index', compact('gallery'));
    }

    public function store(Request $request)
    {

        $this->validate(\request(),
            [
                'title' => 'required|string|max:100',
                'image' => 'required|mimes:png,jpg,jpeg,webp',
            ]);
        try {
            $gallery = new Gallery();
            $gallery->title = $request->title;
            $gallery->add_by = Auth::user()->id;
            $gallery->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $gallery->image = $this->imageUpload($request, 'image', 'uploads/gallery');
            }

            $gallery->save();
            return redirect()->route('gallery.index')->with('success', 'Gallery Created Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', 'Gallery created  failed');
        }

    }

    public function edit($id)
    {

        $gallery = Gallery::find($id);
        $galleries = Gallery::get();
        return view('Admin.gallery.edit', compact('gallery', 'galleries'));
    }

    public function update($id, Request $request)
    {

        $this->validate(\request(),
            [
                // 'title' => 'required|string|min:10|max:100',
                // 'short_description' => 'nullable|string|max:200',
                'image' => 'nullable|mimes:png,jpg,jpeg,webp',

            ]);

        try {
            $gallery = Gallery::find($id);
            $gallery->title = $request->title;
            // $slider->short_description = $request->short_description;
            $gallery->updated_by = Auth::user()->id;
            $gallery->ip_address = $request->ip();
            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $gallery->image = $this->imageUpload($request, 'image', 'uploads/slider');
            }

            $gallery->update();
            return redirect()->route('gallery.index')->with('success', ' Gallery  Update Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Video Update failed');
        }

    }

    public function delete($id)
    {

        try {
            $gallery = Gallery::find($id);
            if (file_exists($gallery->image) && $gallery->image != null) {
                unlink($gallery->image);
            }
            $gallery->delete();
            return redirect()->route('gallery.index')->with('success', ' Gallery Deleted Successful');

        } catch (\Throwable $th) {
            //throw $th;
            return redirect()->back()->with('error', ' Gallery Deleted failed');
        }

    }

    public function videoIndex()
    {

        $video = GalleryVideo::latest()->get();
        return view('Admin.video_gallery.index', compact('video'));
    }

    public function videoStore(Request $request)
    {

        $this->validate(\request(),
            [
                'video' => 'required',
            ]);
        try {
            $video = new GalleryVideo();
            $video->video = $request->video;
            $video->add_by = Auth::user()->id;
            $video->ip_address = $request->ip();

            $video->save();
            return redirect()->route('videos')->with('success', 'Video Created Successful');

        } catch (\Throwable $th) {
            throw $th;
            return redirect()->back()->with('error', 'Video created  failed');
        }

    }

    public function videoEdit($id)
    {

        $video = GalleryVideo::find($id);
        $videos = GalleryVideo::get();
        return view('Admin.video_gallery.edit', compact('video', 'videos'));
    }

    public function videoUpdate($id, Request $request)
    {

        $this->validate(\request(),
            [
                 'video' => 'required',
            ]);

        try {
            $video = GalleryVideo::find($id);
            $video->video = $request->video;
            // $slider->short_description = $request->short_description;
            $video->updated_by = Auth::user()->id;
            $video->ip_address = $request->ip();
            $video->update();
            return redirect()->route('videos')->with('success', ' Video  Update Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', ' Video Update failed');
        }

    }

    public function videoDelete($id)
    {
        try {
            $video = GalleryVideo::find($id);

            if ($video) {
                $video->delete();
                return redirect()->route('videos')->with('success', 'Video Deleted Successfully');
            } else {
                return redirect()->route('videos')->with('error', 'Video not found');
            }

        } catch (\Throwable $th) {
            return redirect()->back()->with('error', 'Video Deletion Failed');
        }
    }

}
