<?php

namespace App\Http\Controllers;

use App\Models\Faq;
use App\Models\Team;
use App\Models\About;
use App\Models\Offer;
use App\Models\Video;
use App\Models\Banner;
use App\Models\Blog;
use App\Models\Gallery;
use App\Models\GalleryVideo;
use App\Models\Slider;
use App\Models\Service;
use App\Models\Speciality;
use App\Models\Testmonial;
use App\Models\TourPackage;
use App\Models\SliderHeading;
use App\Models\ServiceHeading;
use App\Models\TourPackageSpot;
use Illuminate\Support\Facades\View;

class HomeController extends Controller
{
    public function home()
    {

        $slider = Slider::latest()->get();
        $speciality = Speciality::get()->take(4);
        $about = About::first();
        $offer = Offer::first();
        $tourPackages = TourPackage::latest()->get()->take(6);
        $service = Service::get()->take(3);
        $serviceHeading = ServiceHeading::first();
        $video = Video::first();
        $team = Team::get()->take(3);
        $faq = Faq::get();
        $testimonials = Testmonial::get();
        $tourDestination = TourPackage::latest()->get();
        $sliderHeading = SliderHeading::first();
        return view('pages.index', compact('slider', 'speciality', 'about', 'offer', 'tourPackages', 'service', 'serviceHeading', 'video', 'team', 'faq', 'testimonials', 'tourDestination','sliderHeading'));
    }

    public function about()
    {
        $about = About::first();
        $video = Video::first();
        $speciality = Speciality::get();
        $team = Team::get();
        $offer = Offer::first();
        return view('pages.about', compact('about', 'video', 'speciality', 'team', 'offer'));
    }

    public function contact()
    {
        $tourDestination = TourPackage::latest()->get();
        return view('pages.contact', compact('tourDestination'));
    }

    public function blog()
    {
        $blog = Blog::latest()->get();
        return view('pages.blog', compact('blog'));
    }

    public function singleblog($slug)
    {

        $blog = Blog::where('slug',$slug)->first();
        return view('pages.singleblog', compact('blog'));
    }

    public function gallery()
    {
        $data['picture']  = Gallery::latest()->get();
        $data['video']  = GalleryVideo::latest()->get();
        return view('pages.gallery', $data);
    }

    public function service()
    {
        $serviceHeading = ServiceHeading::first();
        $service = Service::get();
        $speciality = Speciality::get();
        $offer = Offer::first();
        return view('pages.service', compact('serviceHeading', 'service', 'speciality', 'offer'));
    }

    public function tourPackages()
    {
        $tourPackages = TourPackage::latest()->get();
        $offer = Offer::first();
        return view('pages.tour_package', compact('tourPackages', 'offer'));
    }

    public function singleTourPackage($id)
    {

        $singleTourPackage = TourPackage::find($id);
        $destination = TourPackage::get();
        return view('pages.single_tour_package', compact('singleTourPackage', 'destination'));
    }

    public function tourPackagesSpot()
    {
        $tourPackages = TourPackageSpot::latest()->get();
        $offer = Offer::first();
        return view('pages.tour_packageSpot', compact('tourPackages', 'offer'));
    }

    public function singleTourPackageSpot($slug)
    {

        $singleTourPackage = TourPackageSpot::where('slug',$slug)->first();
        $destination = TourPackage::get();
        return view('pages.single_tour_packageSpot', compact('singleTourPackage', 'destination'));
    }

}
