<?php

namespace App\Http\Controllers;

use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\TourPackageSpot;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class TourPackageSpotController extends Controller
{
    public function index()
    {

        $tourPackage = TourPackageSpot::latest()->get();
        return view('Admin.tourPackageSpot.index', compact('tourPackage'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required|string|max:255',
            'category' => 'required|string|max:255',
            // 'description' => 'required|string',
            'date' => 'required|date',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
        ]);

        try {

            $slug = Str::slug($request->title);

            // Ensure the slug is unique
            $originalSlug = $slug;
            $i = 1;
            while (TourPackageSpot::where('slug', $slug)->exists()) {
                $slug = $originalSlug . '-' . $i;
                $i++;
            }
            $tourPackage = new TourPackageSpot();
            $tourPackage->title = $request->title;
            $tourPackage->category = $request->category;
            $tourPackage->description = $request->description;
            $tourPackage->slug = $slug;
            $tourPackage->date = $request->date;
            $tourPackage->added_by = Auth::user()->id;
            // $blog->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $tourPackage->image = $this->imageUpload($request, 'image', 'uploads/blog');
            }
            $tourPackage->save();
            return redirect()->route('tourPackageSpot.index')->with('success', 'Tour Package Spot Created Successfully');

        } catch (\Throwable $th) {
              throw $th;
            return redirect()->back()->with('error', 'Tour Package Spot creation failed');
        }
    }


    public function edit($id)
    {

        $tourPackage = TourPackageSpot::find($id);
        $tourPackages = TourPackageSpot::get();
        return view('Admin.tourPackageSpot.edit', compact('tourPackage', 'tourPackages'));
    }

    public function update($id, Request $request)
    {

        $this->validate($request, [
            'title' => 'required|string|max:255',
            'category' => 'required|string|max:255',
            // 'description' => 'required|string',
            'date' => 'required|date',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg',
        ]);

        try {
            $slug = Str::slug($request->title);

            // Ensure the slug is unique
            $originalSlug = $slug;
            $i = 1;
            while (TourPackageSpot::where('slug', $slug)->exists()) {
                $slug = $originalSlug . '-' . $i;
                $i++;
            }
            $tourPackage = TourPackageSpot::find($id);
            $tourPackage->title = $request->title;
            $tourPackage->category = $request->category;
            $tourPackage->description = $request->description;
            $tourPackage->slug = $slug;
            $tourPackage->date = $request->date;
            $tourPackage->updated_by = Auth::user()->id;
            $tourPackage->ip_address = $request->ip();

            // Handle image uploads individually
            if ($request->hasFile('image')) {
                $tourPackage->image = $this->imageUpload($request, 'image', 'uploads/blog');
            }
            $tourPackage->update();
            return redirect()->route('tourPackageSpot.index')->with('success', ' Tour & Packages Update Successful');

        } catch (\Throwable $th) {
            // throw $th;
            return redirect()->back()->with('error', 'Tour & Packages Update failed');
        }

    }

    public function delete($id)
    {
        try {
            // Find the TourPackage by ID
            $tourPackage = TourPackageSpot::find($id);
            // Delete image
            if (file_exists($tourPackage->image) && $tourPackage->image != null) {
                unlink($tourPackage->image);
            }

            // Delete the TourPackage record
            $tourPackage->delete();
            return redirect()->route('tourPackageSpot.index')->with('success', 'Tour & package  deleted successfully.');

        } catch (\Throwable $th) {
            // Catch any errors
            return redirect()->back()->with('error', 'Tour & package Deleted Fail.');
        }
    }
}
