<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('offers', function (Blueprint $table) {
            $table->id();
            $table->text('title_one');
            $table->text('short_description_one');
            $table->string('image_one')->default('no.png');
            $table->string('discount_one');
            $table->text('title_two');
            $table->text('short_description_two');
            $table->string('image_two')->default('no.png');;
            $table->string('discount_two');
            $table->ipAddress('ip_address')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('offers');
    }
};
