<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tour_packages', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('location');
            $table->integer('duration')->default(0);
            $table->string('tour_type');
            $table->integer('group_size')->default(0);
            $table->string('language');
            $table->text('map_url');
            $table->text('overview');
            $table->string('image_one')->default('no.png');;
            $table->string('image_two')->default('no.png');;
            $table->string('image_three')->default('no.png')->nullable();
            $table->string('image_four')->default('no.png')->nullable();
            $table->longtext('long_description')->nullable();

            $table->unsignedBigInteger('add_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->ipAddress('ip_address')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tour_packages');
    }
};
