<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('banners', function (Blueprint $table) {
            $table->id();
            $table->string('about_banner')->default('no.png')->nullable();
            $table->string('contact_banner')->default('no.png')->nullable();
            $table->string('tour_package_banner')->default('no.png')->nullable();
            $table->string('service_banner')->default('no.png')->nullable();

            $table->unsignedBigInteger('updated_by')->nullable();
            $table->ipAddress('ip_address')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banners');
    }
};
