<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;

use App\Models\User;
use App\Models\About;
use App\Models\Banner;
use App\Models\Offer;
use App\Models\Video;
use App\Models\Company;
use App\Models\ServiceHeading;
use App\Models\SliderHeading;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        User::create([
            'name'     => 'Admin',
            'username' => 'admin',
            'email'    => 'admin@gmail.com',
            'password' => Hash::make(1),

        ]);

        Company::create([
            'company_name' => 'Company Name.',
            'phone'        => '01700000000',
            'address'      => 'The Address',
            'email'        => 'rupantorecotourism@gmail.com',
        ]);

        About::create([
            'title'                   => 'This is Title.',
            'details'                 => 'This is Details',
            'year_of_experience'      => '0',
            'no_of_client'            => '0',
        ]);

        Offer::create([
            'title_one'               => 'This is Title one.',
            'title_two'               => 'This is Title tWO.',
            'short_description_one'   => 'This is Short Description',
            'short_description_two'   => 'This is Short Description',
            'discount_one'            => 'This is Discount one',
            'discount_two'            => 'This is Discount Two',
            'image_one'               => 'no.png',
            'image_two'               => 'no.png',
        ]);

        ServiceHeading::create([
            'title'               => 'This is Title .',
            'short_description'   => 'This is Short Description',
            'image_one'           => 'no.png',
            'image_two'           => 'no.png',
        ]);

        Video::create([
            'title'               => 'This is Title .',
            'short_description'   => 'This is Short Description',
            'image'               => 'no.png',
            'video_link'           => 'N/A',
        ]);

        Banner::create([
            'about_banner'         => 'no.png',
            'contact_banner'       => 'no.png',
            'service_banner'       => 'no.png',
            'tour_package_banner'  => 'no.png',
        ]);


        SliderHeading::create([
            'title'               => 'This is Title .',
            'short_description'   => 'This is Short Description',
        ]);

        // \App\Models\User::factory(10)->create();

        // \App\Models\User::factory()->create([
        //     'name' => 'Test User',
        //     'email' => 'test@example.com',
        // ]);
    }
}
