@extends('layouts.master')
@section('title', 'Update Company About')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> > About</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i> Update Company About
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <form method="post" action="{{ route('about.update') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Title<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="title" placeholder="Title"
                                                        value="{{ $about->title }}"
                                                        class="form-control form-control-sm shadow-none" required>
                                                    @error('title')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label for="title" class="col-sm-3 col-form-label">Experience years<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="number" name="year_of_experience"
                                                        placeholder="Year of Experience"
                                                        value="{{ $about->year_of_experience }}"
                                                        class="form-control form-control-sm shadow-none" id="phone"
                                                        required>
                                                    @error('year_of_experience')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Happy Client<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="number" name="no_of_client"
                                                        placeholder="No of happy client " value="{{ $about->no_of_client }}"
                                                        class="form-control form-control-sm shadow-none" required>
                                                    @error('no_of_client')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="inputPassword" class="col-sm-3 col-form-label">Image <span>
                                                        (370X650px) </span><span style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="image" class="form-control shadow-none"
                                                        onchange="mainThambUrl(this)">
                                                    @error('image')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror

                                                    <div class="">
                                                        <img src="{{ $about->image ? asset( $about->image) : asset('no.png') }}"
                                                            id="mainThmb"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Description <span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <textarea name="details" class="ckeditor" cols="30" rows="10">{!! $about->details !!}</textarea>
                                                    @error('details')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-2">
                                    <div class="clearfix">
                                        <div class="text-end m-auto">
                                            <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                            <button type="submit" class="btn btn-success shadow-none">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

@push('scripts')
    <script>
        function mainThambUrl(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#mainThmb').attr('src', e.target.result).width(100)
                        .height(100);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endpush
