@extends('layouts.master')
@section('title', 'Update Banner')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> > Update Banner</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i> Update Banner
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <form method="post" action="{{ route('banner.update') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label class="col-sm-3 col-form-label">About Banner(<small
                                                    class="text-danger">1920
                                                    x 450 px</small>)</label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="about_banner" class="form-control shadow-none"
                                                        id="image" onchange="mainThambUrl(this, 'mainThmb1')">
                                                    @error('about_banner')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{ $banner->about_banner ? asset( $banner->about_banner) : asset('no.png') }}"
                                                            id="mainThmb1"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                                <label class="col-sm-3 col-form-label mt-2">Service Banner(<small
                                                    class="text-danger">1920
                                                    x 450 px</small>)</label>
                                                <div class="col-sm-9 mt-2">
                                                    <input type="file" name="service_banner" class="form-control shadow-none"
                                                        id="image" onchange="mainThambUrl(this, 'mainThmb2')">
                                                    @error('service_banner')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{ $banner->service_banner ? asset( $banner->service_banner) : asset('no.png') }}"
                                                            id="mainThmb2"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label class="col-sm-3 col-form-label">Tour & Package Banner(<small
                                                    class="text-danger">1920
                                                    x 450 px</small>)</label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="tour_package_banner" class="form-control shadow-none"
                                                        id="image" onchange="mainThambUrl(this, 'mainThmb3')">
                                                    @error('tour_package_banner')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{ $banner->tour_package_banner ? asset( $banner->tour_package_banner) : asset('no.png') }}"
                                                            id="mainThmb3"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                                <label class="col-sm-3 col-form-label mt-2">Contact Banner(<small
                                                    class="text-danger">1920
                                                    x 450 px</small>)</label>
                                                <div class="col-sm-9  mt-2">
                                                    <input type="file" name="contact_banner" class="form-control shadow-none"
                                                        id="image" onchange="mainThambUrl(this, 'mainThmb4')">
                                                    @error('contact_banner')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{ $banner->contact_banner ? asset( $banner->contact_banner) : asset('no.png') }}"
                                                            id="mainThmb4"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>


                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-2">
                                    <div class="clearfix">
                                        <div class="text-end m-auto">
                                            <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                            <button type="submit" class="btn btn-success shadow-none">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

@push('scripts')
    <script>
        function mainThambUrl(input, imgElementId) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    // Set the image source and dimensions
                    $('#' + imgElementId).attr('src', e.target.result).width(100).height(100);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endpush
