@extends('layouts.master')
@section('title', 'Tour Booking List')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> >Tour Booking List</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i>Tour Booking List
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="card my-2">
                                        <div class="card-header d-flex justify-content-between">
                                            <div class="table-head"><i class="fas fa-table me-1"></i> Tour Booking List</div>
                                            <div class="float-right">

                                            </div>
                                        </div>
                                        <div class="card-body table-card-body">
                                            <div class="table-responsive">
                                                <table class="table table-bordered text-center" id="datatablesSimple"
                                                    width="100%" cellspacing="0">
                                                    <thead>
                                                        <tr>
                                                            <th>SL</th>
                                                            <th>Name</th>
                                                            <th>Destination</th>
                                                            <th>Start Date</th>
                                                            <th>End Date</th>
                                                            <th>Adult</th>
                                                            <th>Child</th>
                                                            <th>phone</th>
                                                            <th>Email</th>
                                                            <th>Address</th>
                                                            <th>Message</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($bookingList as $key => $item)
                                                            <tr>
                                                                <td>{{ $key + 1 }}</td>
                                                                <td>{{ $item->name }}</td>
                                                                <td>{{ $item->destination }}</td>
                                                                <td>{{ $item->start_date }}</td>
                                                                <td>{{ $item->end_date }}</td>
                                                                <td>{{ $item->adult }}</td>
                                                                <td>{{ $item->chilld }}</td>
                                                                <td>{{ $item->phone }}</td>
                                                                <td>{{ $item->email }}</td>
                                                                <td>{{ $item->address }}</td>
                                                                <td>{{ $item->message }}</td>
                                                                <td>
                                                                    <a href="{{ route('booking.delete', $item->id) }}"
                                                                        onclick="return confirm('Are You Sure?')"
                                                                        class="btn btn-delete"><i
                                                                            class="fa fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

