
@extends('layouts.master')
@section('title', 'FAQ Update')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class="" href="">Home</a> >
                    Farquently Asked Question Update</span>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fab fa-bandcamp"></i> Farquently Asked Question Update
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <form method="post" action="{{ route('faq.update',$faq->id) }}" enctype="multipart/form-data">
                                @csrf
                                <div class="form-group row">
                                    <label for="title" class="col-sm-3 col-form-label">Question Title <span style="color: red">*</span></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="title" placeholder="Title" value="{{$faq->title}}" class="form-control form-control-sm shadow-none" required>
                                        @error('title') <span style="color: red">{{$message}}</span> @enderror
                                    </div>
                                    <label for="title" class="col-sm-3 col-form-label">Question Answer<span style="color: red">*</span></label>
                                    <div class="col-sm-9">
                                        <textarea name="details" placeholder="Question Answer" rows="3" class="form-control form-control-sm shadow-none ckeditor" >{{$faq->details}}</textarea>
                                        @error('details') <span style="color: red">{{$message}}</span> @enderror
                                    </div>
                                </div>
                                <hr class="my-2">
                                <div class="clearfix">
                                    <div class="text-end m-auto">
                                        <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                        <button type="submit" class="btn btn-success shadow-none">Update</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head"><i class="fas fa-table me-1"></i> Fraquently Asked Question List</div>
                            <div class="float-right">

                            </div>
                        </div>
                        <div class="card-body table-card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered text-center" id="datatablesSimple" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th>Question Title</th>
                                            <th>Question Answer</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($faqs as $item)
                                            <tr class="{{ $item->id }}">
                                                <td>{{ $loop->index + 1 }}</td>
                                                <td>{{ $item->title }}</td>
                                                <td>{!!$item->details !!}</td>
                                                <td>
                                                    <a href="{{ route('faq.edit', $item->id) }}" class="btn btn-edit"><i
                                                            class="fas fa-pencil-alt"></i></a>

                                                    <a href="{{ route('faq.delete', $item->id) }}"
                                                        onclick="return confirm('Are You Sure?')" class="btn btn-delete"><i
                                                            class="fa fa-trash"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection

