@extends('layouts.master')
@section('title', 'News Letter List')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> >News Letter List</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i>News Letter List
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="card my-2">
                                        <div class="card-header d-flex justify-content-between">
                                            <div class="table-head"><i class="fas fa-table me-1"></i> News Letter List</div>
                                            <div class="float-right">

                                            </div>
                                        </div>
                                        <div class="card-body table-card-body">
                                            <div class="table-responsive">
                                                <table class="table table-bordered text-center" id="datatablesSimple"
                                                    width="100%" cellspacing="0">
                                                    <thead>
                                                        <tr>
                                                            <th>SL</th>
                                                            <th>Email</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($newsletter as $key => $item)
                                                            <tr>
                                                                <td>{{ $key + 1 }}</td>
                                                                <td>{{ $item->email }}</td>
                                                                <td>
                                                                    <a href="{{ route('newsletter.delete', $item->id) }}"
                                                                        onclick="return confirm('Are You Sure?')"
                                                                        class="btn btn-delete"><i
                                                                            class="fa fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

