@extends('layouts.master')
@section('title', 'Update Tour Offer')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> > Tour Offer</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i> Update Tour Offer
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <form method="post" action="{{ route('offer.update') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Title One<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="title_one" placeholder="Title One"
                                                        value="{{ $offer->title_one }}"
                                                        class="form-control form-control-sm shadow-none" required>
                                                    @error('title_one')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label for="title" class="col-sm-3 col-form-label">Short Details
                                                    One<span style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="short_description_one"
                                                        placeholder="Short Description One"
                                                        value="{{ $offer->short_description_one }}"
                                                        class="form-control form-control-sm shadow-none" required>
                                                    @error('short_description_one')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Discount One<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="discount_one" placeholder="Discount One"
                                                        value="{{ $offer->discount_one }}"
                                                        class="form-control form-control-sm shadow-none" id="email"
                                                        required>
                                                    @error('discount_one')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label class="col-sm-3 col-form-label">Image One<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="image_one" class="form-control shadow-none"
                                                        id="image" onchange="mainThambUrl(this, 'mainThmb1')">
                                                    @error('image_one')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{ $offer->image_one ? asset( $offer->image_one) : asset('no.png') }}"
                                                            id="mainThmb1"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Title Two<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="title_two" placeholder="Title Two"
                                                        value="{{ $offer->title_two }}"
                                                        class="form-control form-control-sm shadow-none" required>
                                                    @error('title_two')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label for="title" class="col-sm-3 col-form-label">Short Details
                                                    Two<span style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="short_description_two"
                                                        placeholder="Short Description Two"
                                                        value="{{ $offer->short_description_two }}"
                                                        class="form-control form-control-sm shadow-none" required>
                                                    @error('short_description_two')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Discount Two<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="discount_two" placeholder="Discount Two"
                                                        value="{{ $offer->discount_two }}"
                                                        class="form-control form-control-sm shadow-none" required>
                                                    @error('discount_two')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label class="col-sm-3 col-form-label">Image Two<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="image_two"
                                                        class="form-control shadow-none" id="image"
                                                        onchange="mainThambUrl(this, 'mainThmb2')">
                                                    @error('image_two')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{ $offer->image_two ? asset( $offer->image_two) : asset('no.png') }}"
                                                            id="mainThmb2"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-2">
                                    <div class="clearfix">
                                        <div class="text-end m-auto">
                                            <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                            <button type="submit" class="btn btn-success shadow-none">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

@push('scripts')
    <script>
        function mainThambUrl(input, imgElementId) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    // Set the image source and dimensions
                    $('#' + imgElementId).attr('src', e.target.result).width(100).height(100);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endpush
