@extends('layouts.master')
@section('title', 'Update Service Heading')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> > Service Heading</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i> Update Service Heading
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <form method="post" action="{{ route('serviceHeading.update') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Title<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="title" placeholder="Title One"
                                                        value="{{ $serviceHeading->title }}"
                                                        class="form-control form-control-sm shadow-none">
                                                    @error('title')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label class="col-sm-3 col-form-label">Image One<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="image_one" class="form-control shadow-none"
                                                        id="image" onchange="mainThambUrl(this, 'mainThmb1')">
                                                    @error('image_one')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{ $serviceHeading->image_one ? asset( $serviceHeading->image_one) : asset('no.png') }}"
                                                            id="mainThmb1"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Short Description<span style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <textarea name="short_description" rows="3" class="form-control form-control-sm shadow-none">{{ $serviceHeading->short_description }}</textarea>
                                                    @error('short_description')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label class="col-sm-3 col-form-label">Image Two<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="image_two"
                                                        class="form-control shadow-none" id="image"
                                                        onchange="mainThambUrl(this, 'mainThmb2')">
                                                    @error('image_two')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{ $serviceHeading->image_two ? asset( $serviceHeading->image_two) : asset('no.png') }}"
                                                            id="mainThmb2"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-2">
                                    <div class="clearfix">
                                        <div class="text-end m-auto">
                                            <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                            <button type="submit" class="btn btn-success shadow-none">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

@push('scripts')
    <script>
        function mainThambUrl(input, imgElementId) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    // Set the image source and dimensions
                    $('#' + imgElementId).attr('src', e.target.result).width(100).height(100);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endpush
