@extends('layouts.master')
@section('title', 'Update Slider Heading')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> > Slider Heading</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i> Update Slider Heading
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <form method="post" action="{{ route('sliderHeading.update') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Title<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="title" placeholder="Title One"
                                                        value="{{ $sliderHeading->title }}"
                                                        class="form-control form-control-sm shadow-none">
                                                    @error('title')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Short Description<span style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <textarea name="short_description" rows="3" class="form-control form-control-sm shadow-none">{{ $sliderHeading->short_description }}</textarea>
                                                    @error('short_description')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                    <hr class="my-2">
                                    <div class="clearfix">
                                        <div class="text-end m-auto">
                                            <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                            <button type="submit" class="btn btn-success shadow-none">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

