@extends('layouts.master')
@section('title', 'Team Update')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> > Team Update</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i> Team Update
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <form method="post" action="{{ route('team.update',$team->id) }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Name<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="name" placeholder="Name"
                                                        value="{{$team->name}}"
                                                        class="form-control form-control-sm shadow-none">
                                                    @error('name')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label for="title" class="col-sm-3 col-form-label">Designation<span style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="designation"
                                                        placeholder="Designation"
                                                         value="{{$team->designation}}"
                                                        class="form-control form-control-sm shadow-none">
                                                    @error('designation')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Email<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="email" name="email" placeholder="Email"
                                                         value="{{$team->email}}"
                                                        class="form-control form-control-sm shadow-none" id="email">
                                                    @error('email')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Phone<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="tel" name="phone" placeholder="Phone Number"
                                                         value="{{$team->phone}}"
                                                        class="form-control form-control-sm shadow-none" id="email"
                                                        >
                                                    @error('phone')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Facebook</label>
                                                <div class="col-sm-9">
                                                    <input type="url" name="facebook" placeholder="Facebook link"
                                                         value="{{$team->facebook}}"
                                                        class="form-control form-control-sm shadow-none">
                                                    @error('facebook')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label for="title" class="col-sm-3 col-form-label">Twitter</label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="twitter"
                                                        placeholder="Twitter Url"
                                                      value="{{$team->twitter}}"
                                                        class="form-control form-control-sm shadow-none" >
                                                    @error('twitter')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label class="col-sm-3 col-form-label">Image (<small
                                                    class="text-danger">404 x 400 px</small>)<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="image"
                                                        class="form-control shadow-none" id="image"
                                                        onchange="mainThambUrl(this, 'mainThmb')">
                                                    @error('image')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{asset($team->image) }}"
                                                            id="mainThmb"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-2">
                                    <div class="clearfix">
                                        <div class="text-end m-auto">
                                            <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                            <button type="submit" class="btn btn-success shadow-none">Update</button>
                                        </div>
                                    </div>
                                </form>

                                <div class="col-lg-12">
                                    <div class="card my-2">
                                        <div class="card-header d-flex justify-content-between">
                                            <div class="table-head"><i class="fas fa-table me-1"></i> Team Member List</div>
                                            <div class="float-right">

                                            </div>
                                        </div>
                                        <div class="card-body table-card-body">
                                            <div class="table-responsive">
                                                <table class="table table-bordered text-center" id="datatablesSimple"
                                                    width="100%" cellspacing="0">
                                                    <thead>
                                                        <tr>
                                                            <th>SL</th>
                                                            <th>Name</th>
                                                            <th>Designation</th>
                                                            <th>Phone</th>
                                                            <th>Email</th>
                                                            <th>Facebook</th>
                                                            <th>Twitter</th>
                                                            <th>Image</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($teams as $key => $item)
                                                            <tr>
                                                                <td>{{ $key + 1 }}</td>
                                                                <td>{{ $item->name }}</td>
                                                                <td>{{ $item->designation }}</td>
                                                                <td>{{ $item->phone }}</td>
                                                                <td>{{ $item->email }}</td>
                                                                <td>{{ $item->facebook }}</td>
                                                                <td>{{ $item->twitter }}</td>
                                                                <td><img width="50" src="{{ asset($item->image) }}"
                                                                        alt=""></td>
                                                                <td>
                                                                    <a href="{{ route('team.edit', $item->id) }}"
                                                                        class="btn btn-edit"><i
                                                                            class="fas fa-pencil-alt"></i></a>

                                                                    <a href="{{ route('team.delete', $item->id) }}"
                                                                        onclick="return confirm('Are You Sure?')"
                                                                        class="btn btn-delete"><i
                                                                            class="fa fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

@push('scripts')
    <script>
        function mainThambUrl(input, imgElementId) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    // Set the image source and dimensions
                    $('#' + imgElementId).attr('src', e.target.result).width(100).height(100);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endpush
