@extends('layouts.master')
@section('title', 'Testimonial (Client Feedback) Entry')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> > Testimonial (Client Feedback) Entry</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i> Testimonial (Client Feedback) Entry
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <form method="post" action="{{ route('testimonials.store') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Name<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="name" placeholder="Name"
                                                        value="{{ old('name') }}"
                                                        class="form-control form-control-sm shadow-none" required>
                                                    @error('name')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label for="title" class="col-sm-3 col-form-label">Profession<span style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="designation"
                                                        placeholder="Profession"
                                                        value="{{old('designation') }}"
                                                        class="form-control form-control-sm shadow-none" required>
                                                    @error('designation')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Rating<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="number" name="rating" placeholder="Rating"
                                                        value="{{ old('rating') }}"
                                                        class="form-control form-control-sm shadow-none" id="email"
                                                        required>
                                                    @error('rating')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Short Description</label>
                                                <div class="col-sm-9">
                                                    <textarea name="short_description" placeholder="Short Description" rows="3" class="form-control form-control-sm shadow-none" >{{ old('short_description') }}</textarea>
                                                    @error('short_description')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label class="col-sm-3 col-form-label">Image (<small
                                                    class="text-danger">404 x 400 px</small>)<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="image"
                                                        class="form-control shadow-none" id="image"
                                                        onchange="mainThambUrl(this, 'mainThmb')">
                                                    @error('image')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{asset('no.png') }}"
                                                            id="mainThmb"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-2">
                                    <div class="clearfix">
                                        <div class="text-end m-auto">
                                            <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                            <button type="submit" class="btn btn-success shadow-none">Update</button>
                                        </div>
                                    </div>
                                </form>

                                <div class="col-lg-12">
                                    <div class="card my-2">
                                        <div class="card-header d-flex justify-content-between">
                                            <div class="table-head"><i class="fas fa-table me-1"></i> Team Member List</div>
                                            <div class="float-right">

                                            </div>
                                        </div>
                                        <div class="card-body table-card-body">
                                            <div class="table-responsive">
                                                <table class="table table-bordered text-center" id="datatablesSimple"
                                                    width="100%" cellspacing="0">
                                                    <thead>
                                                        <tr>
                                                            <th>SL</th>
                                                            <th>Name</th>
                                                            <th>Designation</th>
                                                            <th>Rating</th>
                                                            <th>Short Details</th>
                                                            <th>Image</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($testimonial as $key => $item)
                                                            <tr>
                                                                <td>{{ $key + 1 }}</td>
                                                                <td>{{ $item->name }}</td>
                                                                <td>{{ $item->designation }}</td>
                                                                <td>{{ $item->rating }}</td>
                                                                <td>{{ $item->short_description }}</td>
                                                                <td><img width="50" src="{{ asset($item->image) }}"
                                                                        alt=""></td>
                                                                <td>
                                                                    <a href="{{ route('testimonials.edit', $item->id) }}"
                                                                        class="btn btn-edit"><i
                                                                            class="fas fa-pencil-alt"></i></a>

                                                                    <a href="{{ route('testimonials.delete', $item->id) }}"
                                                                        onclick="return confirm('Are You Sure?')"
                                                                        class="btn btn-delete"><i
                                                                            class="fa fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

@push('scripts')
    <script>
        function mainThambUrl(input, imgElementId) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    // Set the image source and dimensions
                    $('#' + imgElementId).attr('src', e.target.result).width(100).height(100);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endpush
