@extends('layouts.master')
@section('title', 'Tour & Package Update')
@section('main-content')
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class=""
                        href="{{ route('dashboard') }}">Home</a> > Tour & Package Update</span>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fas fa-edit"></i> Tour & Package Update
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <div class="row">
                                <form method="post" action="{{ route('tourPackage.update',$tourPackage->id) }}"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group row">
                                                <label for="title" class="col-sm-3 col-form-label">Title<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="title" placeholder="Title"
                                                        value="{{$tourPackage->title}}"
                                                        class="form-control form-control-sm shadow-none">
                                                    @error('title')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label for="title" class="col-sm-3 col-form-label">Location<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="location" placeholder="Location"
                                                        value="{{$tourPackage->location}}"
                                                        class="form-control form-control-sm shadow-none">
                                                    @error('location')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Map Link<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="map_url" placeholder="Location"
                                                        value="{{$tourPackage->map_url}}"
                                                        class="form-control form-control-sm shadow-none">
                                                    @error('map_url')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Duration (Days)<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="duration" placeholder="Duration"
                                                        value="{{$tourPackage->duration}}"
                                                        class="form-control form-control-sm shadow-none" id="email"
                                                       >
                                                    @error('duration')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Tour Type<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="tour_type" placeholder="Tour Type"
                                                        value="{{$tourPackage->tour_type}}"
                                                        class="form-control form-control-sm shadow-none" id="email"
                                                       >
                                                    @error('tour_type')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Group
                                                    Size(Person)<span style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="group_size" placeholder="Group Size"
                                                        value="{{$tourPackage->group_size}}"
                                                        class="form-control form-control-sm shadow-none" id="email"
                                                       >
                                                    @error('group_size')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                                <label for="title" class="col-sm-3 col-form-label">Language<span
                                                        style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="text" name="language" placeholder="Language"
                                                        value="{{$tourPackage->language}}"
                                                        class="form-control form-control-sm shadow-none" id="email"
                                                      >
                                                    @error('language')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label class="col-sm-3 col-form-label">Image one (<small
                                                        class="text-danger">740
                                                        x 550 px</small>)<span style="color:red">*</span></label>
                                                <div class="col-sm-9">
                                                    <input type="file" name="image_one"
                                                        class="form-control shadow-none" id="image"
                                                        onchange="mainThambUrl(this, 'mainThmb1')">
                                                    @error('image_one')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{asset($tourPackage->image_one)}}" id="mainThmb1"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                                <label class="col-sm-3 col-form-label mt-2">Image Two (<small
                                                        class="text-danger">740
                                                        x 550 px</small>)<span style="color:red">*</span></label>
                                                <div class="col-sm-9 mt-2">
                                                    <input type="file" name="image_two"
                                                        class="form-control shadow-none" id="image"
                                                        onchange="mainThambUrl(this, 'mainThmb2')">
                                                    @error('image_two')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{asset($tourPackage->image_two)}}" id="mainThmb2"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group row">

                                                <label for="title" class="col-sm-3 col-form-label">Overview</label>
                                                <div class="col-sm-9">
                                                    <textarea name="overview" rows="3" class="form-control form-control-sm shadow-none" required>{{ $tourPackage->overview}}</textarea>
                                                    @error('overview')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label for="title" class="col-sm-3 col-form-label">Full
                                                    Description</label>
                                                <div class="col-sm-9">
                                                    <textarea name="long_description" rows="4" class="form-control form-control-sm shadow-none ckeditor">{!! $tourPackage->long_description!!}</textarea>
                                                    @error('long_description')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                                <label class="col-sm-3 col-form-label mt-2">Image Three (<small
                                                        class="text-danger">404
                                                        x 400 px</small>)<span style="color:red">*</span></label>
                                                <div class="col-sm-9 mt-2">
                                                    <input type="file" name="image_three"
                                                        class="form-control shadow-none" id="image"
                                                        onchange="mainThambUrl(this, 'mainThmb3')">
                                                    @error('image_three')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{asset($tourPackage->image_three)}}" id="mainThmb3"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                                <label class="col-sm-3 col-form-label mt-2">Image Four (<small
                                                        class="text-danger">404
                                                        x 400 px</small>)<span style="color:red">*</span></label>
                                                <div class="col-sm-9 mt-2">
                                                    <input type="file" name="image_four"
                                                        class="form-control shadow-none" id="image"
                                                        onchange="mainThambUrl(this, 'mainThmb4')">
                                                    @error('image_four')
                                                        <span style="color: red">{{ $message }}</span>
                                                    @enderror
                                                    <div>
                                                        <img src="{{asset($tourPackage->image_four)}}" id="mainThmb4"
                                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-2">
                                    <div class="clearfix">
                                        <div class="text-end m-auto">
                                            <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                            <button type="submit" class="btn btn-success shadow-none">Update</button>
                                        </div>
                                    </div>
                                </form>

                                <div class="col-lg-12">
                                    <div class="card my-2">
                                        <div class="card-header d-flex justify-content-between">
                                            <div class="table-head"><i class="fas fa-table me-1"></i> Tour & Packages List
                                            </div>
                                            <div class="float-right">

                                            </div>
                                        </div>
                                        <div class="card-body table-card-body">
                                            <div class="table-responsive">
                                                <table class="table table-bordered text-center" id="datatablesSimple"
                                                    width="100%" cellspacing="0">
                                                    <thead>
                                                        <tr>
                                                            <th>SL</th>
                                                            <th>Title</th>
                                                            <th>Location</th>
                                                            <th>Duration</th>
                                                            <th>Tour Type</th>
                                                            <th>Group Size</th>
                                                            <th>Language</th>
                                                            <th>Image One</th>
                                                            <th>Image Two</th>
                                                            <th>Image Three</th>
                                                            <th>Image Four</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($tourPackages as $key => $item)
                                                            <tr>
                                                                <td>{{ $key + 1 }}</td>
                                                                <td>{{ $item->title }}</td>
                                                                <td>{{ $item->location }}</td>
                                                                <td>{{ $item->duration }}</td>
                                                                <td>{{ $item->tour_type }}</td>
                                                                <td>{{ $item->group_size }}</td>
                                                                <td>{{ $item->language }}</td>
                                                                <td><img width="50" src="{{ asset($item->image_one) }}"
                                                                        alt=""></td>
                                                                <td><img width="50" src="{{ asset($item->image_two) }}"
                                                                        alt=""></td>
                                                                <td><img width="50" src="{{ asset($item->image_three) }}"
                                                                        alt=""></td>
                                                                <td><img width="50" src="{{ asset($item->image_four) }}"
                                                                        alt=""></td>
                                                                <td>
                                                                    <a href="{{ route('tourPackage.edit', $item->id) }}"
                                                                        class="btn btn-edit"><i
                                                                            class="fas fa-pencil-alt"></i></a>

                                                                    <a href="{{ route('tourPackage.delete', $item->id) }}"
                                                                        onclick="return confirm('Are You Sure?')"
                                                                        class="btn btn-delete"><i
                                                                            class="fa fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
@endsection

@push('scripts')
    <script>
        function mainThambUrl(input, imgElementId) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    // Set the image source and dimensions
                    $('#' + imgElementId).attr('src', e.target.result).width(100).height(100);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endpush
