@extends('layouts.master')
@section('title', 'Tour & Package Spot Update')
@section('main-content')
<main>
    <div class="container-fluid" id="Category">
        <div class="heading-title p-2 my-2">
            <span class="my-3 heading "><i class="fas fa-home"></i> <a class="" href="">Home</a> >
                Tour & Package Spot Entry</span>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card my-2">
                    <div class="card-header d-flex justify-content-between">
                        <div class="table-head">
                            <i class="fab fa-bandcamp"></i> Tour & Package Spot Update
                        </div>
                    </div>

                    <div class="card-body table-card-body">
                        <form method="post" action="{{ route('tourPackageSpot.update',$tourPackage->id) }}" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group row">
                                <label for="title" class="col-sm-3 col-form-label">Title <span
                                        style="color: red">*</span></label>
                                <div class="col-sm-9">
                                    <input type="text" name="title" placeholder="Title" value="{{$tourPackage->title}}"
                                        class="form-control form-control-sm shadow-none" >
                                    @error('title')
                                    <span style="color: red">{{ $message }}</span>
                                    @enderror
                                </div>
                                <label for="title" class="col-sm-3 col-form-label">Category <span
                                        style="color: red">*</span></label>
                                <div class="col-sm-9">
                                    <input type="text" name="category" placeholder="Category"
                                        value="{{$tourPackage->category}}" class="form-control form-control-sm shadow-none">
                                    @error('category')
                                    <span style="color: red">{{ $message }}</span>
                                    @enderror
                                </div>
                                <label for="Date" class="col-sm-3 col-form-label">Date <span
                                        style="color: red">*</span></label>
                                <div class="col-sm-9">
                                    <input type="date" class="form-control" name="date" id="date"
                                        value="{{ $tourPackage->date}}">
                                    @error('date')
                                    <span style="color: red">{{ $message }}</span>
                                    @enderror
                                </div>
                                <label for="Date" class="col-sm-3 col-form-label">Added By <span
                                        style="color: red">*</span></label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" value="{{ Auth::user()->name }}" readonly>
                                </div>
                                <label for="title" class="col-sm-3 col-form-label">Full
                                    Description</label>
                                <div class="col-sm-9">
                                    <textarea name="description" rows="4"
                                        class="form-control form-control-sm shadow-none ckeditor">{!!$tourPackage->description!!}</textarea>
                                    @error('description')
                                    <span style="color: red">{{ $message }}</span>
                                    @enderror
                                </div>
                                <label for="inputPassword" class="col-sm-3 col-form-label mt-2">Image <span
                                        style="color: red">*</span></label>
                                <div class="col-sm-9 mt-2">
                                    <input type="file" name="image" class="form-control shadow-none"
                                        onchange="mainThambUrl(this)">
                                    @error('image')
                                    <span style="color: red">{{ $message }}</span>
                                    @enderror
                                    <div>
                                        <img src="{{ asset($tourPackage->image) }}" id="mainThmb"
                                            style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                            alt="">
                                    </div>
                                </div>
                            </div>
                            <hr class="my-2">
                            <div class="clearfix">
                                <div class="text-end m-auto">
                                    <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                    <button type="submit" class="btn btn-success shadow-none">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="card my-2">
                    <div class="card-header d-flex justify-content-between">
                        <div class="table-head"><i class="fas fa-table me-1"></i> Tour & Package Spot List</div>
                        <div class="float-right">

                        </div>
                    </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered text-center" id="datatablesSimple" width="100%"
                                cellspacing="0">
                                <thead>
                                    <tr>
                                        <th>SL</th>
                                        <th>Title</th>
                                        <th>Category</th>
                                        <th>Date</th>
                                        <th>Image</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($tourPackages as $item)
                                    <tr class="{{ $item->id }}">
                                        <td>{{ $loop->index + 1 }}</td>
                                        <td>{{ $item->title }}</td>
                                        <td>{{ $item->category }}</td>
                                        <td>{!! Str::limit($item->description,100, '...') !!}</td>
                                        <td><img src="{{ asset($item->image) }}" width="30" height="30" alt=""></td>
                                        <td>
                                            <a href="{{ route('tourPackageSpot.edit', $item->id) }}" class="btn btn-edit"><i
                                                    class="fas fa-pencil-alt"></i></a>

                                            <a href="{{ route('tourPackageSpot.delete', $item->id) }}"
                                                onclick="return confirm('Are You Sure?')" class="btn btn-delete"><i
                                                    class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection

@push('scripts')
<script>
    function mainThambUrl(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#mainThmb').attr('src', e.target.result).width(100)
                        .height(100);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
</script>
@endpush
