@extends('layouts.web_master')
<style>
    .form-group label {
        font-size: 15px !important;
        font-weight: 500 !important;

    }

    .form-group input {
        height: 42px;
        padding: 5px 15px;
    }

    .ac-layout {
        padding-bottom: 50px;
    }
</style>
@section('main_content')
    <section class="after-header p-tb-10">
        <div class="container">
            <ul class="breadcrumb">
                <li><a href="{{route('home')}}"><i class="material-icons" title="Home">home</i></a></li>
                <li><a href="{{route('customer.dashboard')}}">Account</a></li>
                <li><a href="{{route('customer.password')}}">Change Password</a></li>
            </ul>
        </div>
    </section>
    <div class="container ac-layout">
        @include('partials.customer_header')
        @include('partials.customer_nav')
        <div class="ac-title"><a href=""><span
                    class="material-icons">arrow_back</span></a>
            <h1>Change Password</h1>
        </div>
        <div class="ac-title-help-text">Please type and confirm to change your current password.</div>
        <form action="{{ route('customerPassword.update') }}" method="post">
            @csrf
            <!-- Old Password -->
            <div class="form-group required">
                <label for="input-old">Old Password</label>
                <input type="password" name="old_password" placeholder="Old Password" id="input-old" class="form-control" required>
                @error('old_password')
                <span class="invalid-feedback" role="alert">
                    <strong style="color: red">{{ $message }}</strong>
                </span>
                @enderror
            </div>

            <!-- New Password -->
            <div class="form-group required">
                <label for="input-password">New Password</label>
                <input type="password" name="password" placeholder="New Password" id="input-password" class="form-control" required>
                @error('password')
                <span class="invalid-feedback" role="alert">
                    <strong style="color: red">{{ $message }}</strong>
                </span>
                @enderror
            </div>

            <!-- Confirm New Password -->
            <div class="form-group required">
                <label for="input-confirm">Password Confirm</label>
                <input type="password" name="password_confirmation" placeholder="Password Confirm" id="input-confirm" class="form-control" required>
                @error('password_confirmation')
                <span class="invalid-feedback" role="alert">
                    <strong style="color: red">{{ $message }}</strong>
                </span>
                @enderror
            </div>

            <button type="submit" class="btn btn-primary">Continue</button>
        </form>


    </div>
@endsection
