<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rupantor Eco Tourism</title>
    <link rel="shortcut icon" href="{{ asset($info->logo) }}" type="image/x-icon">

    <!-- Framework CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap-lib-bootstrap.min.css') }}">
    <!-- Font Awesome / Icon Fonts -->
    <link rel="stylesheet" href="{{ asset('assets/css/icon-font-awesome.min.css') }}">
    <!-- Style Theme -->
    <link rel="stylesheet" href="{{ asset('assets/css/css-style.css') }}">
    <!-- Responsive Theme -->
    <link rel="stylesheet" href="{{ asset('assets/css/css-responsive.css') }}">
    <!-- Slider -->
    <link rel="stylesheet" href="{{ asset('assets/css/css-slick.min.css') }}">
    <!-- AOS Animation -->
    <link rel="stylesheet" href="{{ asset('assets/css/css-aos.css') }}">
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- toaster -->
    <link href="{{ asset('back_asset/css/toastr.min.css') }}" rel="stylesheet" />

    @stack('web-css')
</head>

<body>
    <!-- Site Wrapper -->
    <div class="site-wrapper">
        <!-- Header Slider Start -->
        @yield('header-content')
        <div class="overlay">
            <div class="header-content">
                <!-- ====== 1.1 Header Section ====== -->
                @include('partials.header')
                @yield('header-text')
            </div>
        </div>

        @yield('main-content')

        @include('partials.footer')
    </div>

    <!-- Button Back to Top -->
    <button onclick="scrollToTop()" id="backToTopBtn" class="btn_hover2">
        <i class="fa-solid fa-arrow-turn-up"></i>
    </button>

    <!-- jQuery -->
    <script data-cfasync="false" src="{{ asset('assets/js/cloudflare-static-email-decode.min.js') }}"></script>
    <script src="{{ asset('assets/js/js-jquery.js') }}"></script>
    <!-- Counter -->
    <script src="{{ asset('assets/js/js-waypoints.min.js') }}"></script>
    <!-- Framework JavaScript -->
    <script src="{{ asset('assets/js/javascript-lib-bootstrap.min.js') }}"></script>
    <!-- Slider -->
    <script src="{{ asset('assets/js/js-slick.min.js') }}"></script>
    <!-- Custom JavaScript -->
    <script src="{{ asset('assets/js/js-custom.js') }}"></script>
    <!-- AOS Animation -->
    <script src="{{ asset('assets/js/js-aos.js') }}"></script>
    <!-- toaster-->
    <script src="{{ asset('back_asset/js/toastr.min.js') }}"></script>

    <script>
        // AOS Animation Start
        AOS.init({
            once: true,
            duration: 1000
        });
        // AOS Animation End

        // Header Slider
        const slides = document.querySelectorAll('.slide');
        let currentSlide = 0;

        function changeSlide() {
            slides[currentSlide].classList.remove('active');
            currentSlide = (currentSlide + 1) % slides.length;
            slides[currentSlide].classList.add('active');
        };
        setInterval(changeSlide, 5000);
    </script>

    <script>
        (function() {
            function c() {
                var b = a.contentDocument || a.contentWindow.document;
                if (b) {
                    var d = b.createElement('script');
                    d.innerHTML =
                        "window.__CF$cv$params={r:'8d5ff5551fcf7676',t:'MTcyOTUwMDE4OS4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";
                    b.getElementsByTagName('head')[0].appendChild(d);
                }
            }
            if (document.body) {
                var a = document.createElement('iframe');
                a.height = 1;
                a.width = 1;
                a.style.position = 'absolute';
                a.style.top = 0;
                a.style.left = 0;
                a.style.border = 'none';
                a.style.visibility = 'hidden';
                document.body.appendChild(a);
                if ('loading' !== document.readyState) c();
                else if (window.addEventListener) document.addEventListener('DOMContentLoaded', c);
                else {
                    var e = document.onreadystatechange || function() {};
                    document.onreadystatechange = function(b) {
                        e(b);
                        'loading' !== document.readyState && (document.onreadystatechange = e, c());
                    };
                }
            }
        })();
    </script>

    <script>
        @if (Session::has('update'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("{{ session('update') }}");
        @endif

        @if (Session::has('message'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("{{ session('message') }}");
        @endif
        @if (Session::has('success'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("{{ session('success') }}");
        @endif


        @if (Session::has('error'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.error("{{ session('error') }}");
        @endif
    </script>
</body>

</html>
