@extends('layouts.web_master')

@section('header-content')
    <!-- header slider start -->
    <div class="header-slider">
        @foreach ($slider as $item)
        <div class="slide active">
            <img src="{{ asset($item->image) }}" alt="slider-img">
        </div>
        @endforeach

    </div>
    <!-- header slider end -->
@endsection

@section('header-text')
    <!-- ====== 1.2 hero section ====== -->
    <section id="hero">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-11 col-md-12 text-center" data-aos="fade">
                    {{-- <h1>{{$sliderHeading->title}}</h1> --}}
                    <h1>{{$sliderHeading->title}}</h1>
                    <p>{{$sliderHeading->short_description}}
                    </p>
                    <div class="globalBtn mt-4">
                        <ul>
                            <li>
                                <a href="{{ url('about') }}"> Discover Now
                                    <span></span><span></span><span></span><span></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.2 hero section ====== -->
@endsection

@section('main-content')
    <!-- ====== 1.3 features section ====== -->
    <section id="features">
        <div class="container card-text">
            <div class="row">
                @foreach ($speciality  as $key => $item)


                <div class="col-md-3" data-aos="fade-up" data-aos-delay="{{ 100 + ($key * 200) }}">
                    <div>
                        <figure><img src="{{ asset($item->icon) }}" alt="featureIcon"></figure>
                        <h6>{{$item->title}}</h6>
                        <p style="text-align: justify">{{ Str::limit($item->short_description, 100, '...') }}
                        </p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
    <!-- ====== End 1.3 features section ====== -->

    <!-- ====== 1.4 about section ====== -->
    <section id="about">
        {{-- <div class="blueBg"></div> --}}
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-md-9">
                    {{-- <form  method="post" action="{{route('booking')}}"
                        class="d-flex gap-lg-2 gap-md-1 gap-sm-4 gap-3 justify-content-evenly align-items-md-center"
                        data-aos="fade-down">
                        @csrf
                        <div id="about-message"></div>
                        <div>
                            <h6>Name</h6>
                            <input type="text" name="name" placeholder="Your Name" required>
                        </div>
                        <div>
                            <h6>Destination</h6>
                            <select name="destination" >
                                <option value="" selected disabled>Destination</option>
                                @foreach ($tourDestination as $item)
                                <option value="{{$item->title}}">{{$item->title}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <h6>Tour Days</h6>
                            <input type="date" name="start_date" required>
                        </div>
                        <div class="globalBtn">
                            <ul>
                                <li>
                                    <button type="submit">Book Now
                                        <span></span><span></span><span></span><span></span>
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </form> --}}
                    <div class="col-lg-10 col-md-9" data-aos="fade-up">
                        <div>
                            <h4>About Us</h4>
                            <h2>{{$about->title}}</h2>
                            <div style="text-align: justify">{!! $about->details!!}</div>
                            <div class="globalBtnActive justify-content-md-start justify-content-center mt-4">
                                <ul>
                                    <li>
                                        <a href="{{route('about') }}"> Learn More
                                            <span></span><span></span><span></span><span></span>
                                            <i class="fa-solid fa-arrow-right"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-9 col-12 about-Image">
                    <div class="aboutImg position-relative" data-aos="fade-up" style="margin-top:3rem">
                        <figure>
                            <img src="{{ asset($about->image) }}" alt="about-sec">
                        </figure>
                        <div class="customer d-flex flex-column justify-content-between align-items-center">
                            <div class="d-flex">
                                <h2 class="count">{{$about->no_of_client}} </h2>
                                <h2>+</h2>
                            </div>
                            <p>Happy Customers</p>
                        </div>
                        <div class="experience d-flex flex-column justify-content-between align-items-center"
                            data-aos="fade-up">
                            <div class="d-flex">
                                <h2 class="count">{{$about->year_of_experience}}</h2>
                                <h2>+</h2>
                            </div>
                            <p>Years of experience</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.4 about section ====== -->

    <!-- ====== 1.5 special offer section ====== -->
    <section id="special">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6" data-aos="fade-down">
                    <h3>{{$offer->title_one}} </h3>
                    <p>{{ Str::limit($offer->short_description_one, 120, '...') }}</p>
                    <div class="offer">
                        <img src="{{ asset($offer->image_one) }}" alt="discount">
                        <div class="overlaytwo">
                            <div class="overlay_text">
                                <h3>Discount up {{$offer->disscount_one}}</h3>
                                <div class="globalBtn mt-lg-5 mt-4">
                                    <ul>
                                        <li>
                                            <a href="{{ route('contact') }}">Book Now
                                                <span></span><span></span><span></span><span></span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mt-md-0 mt-4" data-aos="fade-up">
                    <div class="offer">
                        <img src="{{ asset($offer->image_two) }}" alt="discount">
                        <div class="overlaytwo">
                            <div class="overlay_text">
                                <h3>Discount up {{$offer->discount_two}}</h3>
                                <div class="globalBtn mt-lg-5 mt-4">
                                    <ul>
                                        <li>
                                            <a href="{{ url('contact') }}">Book Now
                                                <span></span><span></span><span></span><span></span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h3>{{$offer->title_two}}</h3>
                    <p>{{ Str::limit($offer->short_description_two, 120, '...') }}.</p>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.5 special offer section ====== -->
    <!-- ====== 1.6 tours section ====== -->
    <section id="tour">
        <div class="container">
            <div data-aos="fade" data-aos-duration="2000">
                <h4>Tour & Packages</h4>
                <h2>Live Your Life Through Travel</h2>
                <div class="d-flex flex-md-row flex-column gap-3 justify-content-between align-items-center mt-3">
                    <div class="tourPara">
                        {{-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt
                            ut
                            labore et dolore magna aliqua.</p> --}}
                    </div>
                    <div class="globalBtnActive">
                        <ul>
                            <li>
                                <a href="{{route('tourPackages')}}"> View all
                                    <span></span><span></span><span></span><span></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="tourCards card-text mt-5">
                <div class="row gap-4 ">
                    @foreach ($tourPackages as $key => $item )

                    <div class="col-md-4 col-sm-5 col-11" data-aos="fade-up" data-aos-delay="{{ 100 + ($key * 200)}}">
                        <div>
                            <figure>
                                <img src="{{asset($item->image_one)}}" alt="tour-img">
                            </figure>
                            <h6>{{$item->title}}</h6>
                            <p>{{ Str::limit($item->overview, 80, '...') }}</p>
                            <a href="{{route('singleTourPackage',$item->id)}}">Learn More <i class="fa-solid fa-arrow-right"></i></a>
                        </div>
                    </div>
                    @endforeach

                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.6 tours section ====== -->

    <!-- ====== 1.7 why choose us section ====== -->
    <section id="choose">
        <div class="chooseBg">
            <div class="position-relative z-2" data-aos="fade" data-aos-duration="2000">
                <h4>Why choose us</h4>
                <h2>Let Us Show You The Beauty
                    Of The World</h2>
                <div class="globalBtn mt-lg-5 mt-md-5">
                    <ul>
                        <li>
                            <a href="{{route('contact')}}">contact us
                                <span></span><span></span><span></span><span></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="chooseCrads position-relative z-2">
            <div class="container">
                <div class="row gap-md-0 gap-4 justify-content-center card-text">
                    @foreach($speciality as $key => $item)
                    <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="{{ 100 + ($key * 100) }}">
                        <div>
                            <figure>
                                <img src="{{asset($item->icon)}}" alt="chooseIcon">
                            </figure>
                            <h6>{{$item->title}}</h6>
                            <p style="text-align: justify">
                                {{ Str::limit($item->short_description, 130, '...') }}
                            </p>
                        </div>
                    </div>
                @endforeach

                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.7 why choose us section ====== -->

    <!-- ====== 1.8 services section ====== -->
    <section id="services">
        <div class="container">
            <div class="row">
                <div class="col-md-7">
                    <div data-aos="fade" data-aos-duration="2000">
                        <h4>Our Services</h4>
                        <h2>{{ $serviceHeading->title}}</h2>
                        <p>{{$serviceHeading->short_description}}
                        </p>
                        <div class="row align-items-center gap-lg-3 gap-md-4 text-lg-start text-center">
                            @foreach ($service as $item )
                            <div class="col-md-3">
                                <div>
                                    <figure>
                                        <img src="{{asset($item->icon)}}" alt="servicesIcon">
                                    </figure>
                                <h6>{{$item->title}}</h6>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        <div
                            class="globalBtnActive d-flex justify-content-md-start justify-content-center mt-lg-3 mt-md-3 mt-4">
                            <ul>
                                <li>
                                    <a href="{{route('service')}}">See all services
                                        <span></span><span></span><span></span><span></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5 mt-md-0 mt-5" data-aos="fade-up" data-aos-easing="ease-in-out-quad">
                    <div>
                        <figure>
                            <img src="{{asset($serviceHeading->image_one)}}" alt="service-img">
                        </figure>
                        <figure>
                            <img src="{{asset($serviceHeading->image_two)}}" alt="ser-Camera">
                        </figure>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.8 services section ====== -->

    <!-- ====== 1.9 what we do section ====== -->
    <section id="weDo">
        <div class="container">
            <div class="row">
                <div class="col-md-6 d-flex justify-content-center">
                    <div class="weDo-video">
                        <div>
                            <a class="video-play-button" href="{{$video->video_link}}" target="_blank">
                                <span class="fa-solid fa-play"></span>
                            </a>
                        </div>
                        <figure>
                            <img src="{{asset('assets/images/index-wedo-img.webp')}}"  alt="weDo" style="height:679px">
                        </figure>
                    </div>
                </div>
                <div class="col-md-6 d-flex justify-content-center align-content-center">
                    <div class="weDo-content d-flex flex-column justify-content-center align-items-start">
                        <div data-aos="fade" data-aos-duration="2000">
                            <h2>{{$video->title}}</h2>
                            <p>{{ $video->short_description}}</p>
                        </div>
                        <div class="globalBtnActive mt-3" data-aos="fade" data-aos-duration="2000">
                            <ul>
                                <li>
                                    <a href="{{route('service')}}"> Learn More
                                        <span></span><span></span><span></span><span></span>
                                        <i class="fa-solid fa-arrow-right"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.9 what we do section ====== -->

    <!-- ====== 1.10 our team section ====== -->
    <section id="team">
        <div class="container">
            <div data-aos="fade" data-aos-duration="2000">
                <h4>Our Team</h4>
                <h2>Experience The World With Us</h2>
            </div>

            <div class="row justify-content-md-between justify-content-center gap-md-0 gap-4">

                @foreach ($team as $key => $item )

                <div class=" col-md-4 col-sm-8 col-10" data-aos="fade-up" data-aos-delay="{{ 100 + ($key * 200) }}">
                    <div class="teamCard">
                        <img src="{{asset($item->image)}}" alt="teamimg">
                        <div class="overlaythree">
                            <div class="overlay_text">
                                <div class="d-flex justify-content-center gap-2">

                                    <a href="mailto:{{$item->email}}" target="_blank"><i class=" fa-regular fa-envelope"></i></a>
                                    <a href="tel:{{$item->phone}}" target="_blank"><i class="fa-solid fa-phone"></i></a>
                                    <a href="{{$item->facebook}}" target="_blank"><i class="fa-brands fa-facebook-f"></i></a>
                                    <a href="{{$item->twitter}}" target="_blank"><i class="fa-brands fa-twitter"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div>
                        <h6>{{$item->name}}</h6>
                        <p>{{ $item->designation}}</p>
                    </div>
                </div>
                @endforeach

            </div>
        </div>
    </section>

    <!-- ====== End 1.10 our team section ====== -->

    <!-- ====== 1.11 faq section ====== -->
    <section id="faq">
        <div class="container">
            <div class="faq-section">
                <div data-aos="fade">
                    <h4>FAQ</h4>
                    <h2>Have Answers, Will Travel.</h2>
                </div>
                <div class="accordion" id="accordionExample" data-aos="fade">
                    @foreach ($faq as $key => $item)
                    <div class="accordion-item">
                        <h6 class="accordion-header" id="heading{{ $key }}">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse{{ $key }}" aria-expanded="false" aria-controls="collapse{{ $key }}">
                                {{$item->title}}
                            </button>
                        </h6>
                        <div id="collapse{{ $key }}" class="accordion-collapse collapse" aria-labelledby="heading{{ $key }}"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <div>{!! $item->details !!}</div>
                            </div>
                        </div>
                    </div>
                @endforeach


                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.11 faq section ====== -->

    <!-- ====== 1.12 testimonials section ====== -->
    <section id="testimonials">
        <div class="container">
            <div class="row card-text justify-content-md-between justify-content-center gap-md-0 gap-3">
                <div data-aos="fade" data-aos-duration="2000">
                    <h4>Testimonials</h4>
                    <h2>We're All About Your Satisfaction</h2>
                </div>
                @foreach ($testimonials as $item )

                <div class="col-md-4 col-sm-8 col-11" data-aos="fade-up" data-aos-delay="100">
                    <div class="d-flex flex-column align-items-center justify-content-center">
                        <figure>
                            <img src="{{asset($item->image)}}" alt="testimonialsImg">
                        </figure>
                        <h6>{{$item->name}}</h6>
                        <p>{{$item->designation}}</p>
                        <div class="d-flex gap-2 mt-3 mb-4 pb-2">
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                        </div>
                        <p>{{ Str::limit($item->short_description, 180, '...') }}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
    <!-- ====== End 1.12 testimonials section ====== -->

    <!-- ====== 1.14 start planning section ====== -->
    <section id="planning">
        <div class="planningContent" data-aos="fade" data-aos-duration="2000">
            <h3>Start Planning Your Trip Now and <span>Get {{$offer->discount_one}} Discount</span></h3>
            <p>{{ Str::limit($offer->short_description_one, 120, '...') }}</p>
            <div class="globalBtn mt-lg-4 mt-3">
                <ul>
                    <li>
                        <a href="{{route('contact')}}">Book Now
                            <span></span><span></span><span></span><span></span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </section>
    <!-- ====== End 1.14 start planning section ====== -->

    <!-- ====== 1.16 newsletter section ====== -->
    <section id="newsletter">
        <div class="container">
            <div data-aos="fade" data-aos-duration="2000">
                <h4>Newsletter</h4>
                <h2>Stay In The Know, Without Having To Do Anything</h2>
            </div>
            <div class="row justify-content-between" data-aos="fade" data-aos-duration="2000">
                <div class="col-md-5">
                    <div>
                        <p>
                            You can email us for any inquiries and ask anything about our tours!
                        </p>
                    </div>
                </div>
                <div class="col-md-7">
                    <div class="d-md-flex justify-content-lg-end justify-content-md-end justify-content-center">
                        <form  method="post" action="{{route('newsletter')}}">
                            @csrf
                            <div id="newsletter-message"></div>
                            <input type="email" name="email"  placeholder="Enter Your Email Address"
                                required>
                            <div class="globalBtnActive">
                                <ul>
                                    <li>
                                        <button type="submit">Subscribe
                                            <span></span><span></span><span></span><span></span>
                                        </button>
                                    </li>
                                </ul>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.16 newsletter section ====== -->
@endsection
