@extends('layouts.web_master')

@section('header-content')
    <div class="header-destination" style="background: url({{asset($banner->tour_package_banner)}}); background-position: center !important;
        background-repeat: no-repeat !important;
        background-size: cover !important;">
        <!-- ====== 3.1 hero section ====== -->
        <section class="hero">
            <div class="container">
                <div class="row justify-content-center mt-5">
                    <div class="col-lg-11 col-md-12 text-center" data-aos="fade">
                        <div>
                            <h2>Tour & Packages</h2>
                            <div class="d-flex justify-content-center gap-4 pt-4">
                                <nav aria-label="breadcrumb">
                                    <div class="breadcrumb d-flex gap-4 align-items-center">
                                        <div class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></div>
                                        <i class="fa-solid fa-angles-right"></i>
                                        <div class="breadcrumb-item" aria-current="page">Tour & Packages</div>
                                    </div>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!-- ====== End 3.1 hero section ====== -->
@endsection
<style>
    .overlay {
        height: 347px !important;
    }
</style>
@section('main-content')
    <!-- ====== 1.4 about section ====== -->
    <section>
        <div class="container mt-lg-5 mt-md-5 mt-0 pt-lg-5 pt-md-4 pt-0">
            <div class="row">
                <div class="col-lg-9 col-md-10">
                    <div class="row mb-4">
                        <div class="col-lg-8 col-md-9 aos-init aos-animate" data-aos="fade" data-aos-duration="2000">
                            <img src="{{ asset($singleTourPackage->image_one) }}"
                                style="width: 100%; height: 240px; border-radius: .25rem;" alt=""
                                onclick="openModal();">
                        </div>

                        <!-- Modal Structure -->
                        <div id="imageModal" class="modal" onclick="closeModal();">
                            <span class="close" onclick="closeModal();">&times;</span>
                            <img class="modal-content" id="modalImage" src="">
                        </div>

                        <div class="col-lg-4 col-md-5 aos-init aos-animate" data-aos="fade" data-aos-duration="2000">
                            <img src="{{ asset($singleTourPackage->image_two) }}"
                                style="width: 100%; height: 240px; border-radius: .25rem;" alt=""
                                onclick="openModal();">
                        </div>
                    </div>
                    <div class="row ">
                        <div class="col-lg-4 col-md-5 aos-init aos-animate" data-aos="fade" data-aos-duration="2000">
                            <img src="{{ asset($singleTourPackage->image_three) }}"
                                style="width: 100%; height: 240px; border-radius: .25rem;" alt=""
                                onclick="openModal();">
                        </div>
                        <div class="col-lg-8 col-md-9 aos-init aos-animate" data-aos="fade" data-aos-duration="2000">
                            <img src="{{ asset($singleTourPackage->image_four) }}"
                                style="width: 100%; height: 240px; border-radius: .25rem;" alt=""
                                onclick="openModal();">
                        </div>
                    </div>

                    <div class="package-details">
                        <h3 class="mt-5">{{ $singleTourPackage->title }}</h3>
                        <div class="location mt-3 text-slate-600">
                            <p><i class="fa-solid fa-location-dot"></i> {{ $singleTourPackage->location }} </p>
                        </div>

                        <div class="package-content mt-4 mb-5">
                            <div class="row">
                                <div class="col-lg-3 col-md-4 col-sm-3 d-flex">
                                    <i class="fa-regular fa-clock mt-2 " style="font-size: 27px;color: #fb8e26;"></i>
                                    <div>
                                        <p style="font-weight: 500;padding: 0px 10px 0px 10px;">Duration</p>
                                        <P class="text-slate-600"
                                            style="font-weight: 300;padding: 0px 10px 0px 10px;font-size:13px;">
                                            {{ $singleTourPackage->duration }}
                                            DAYS</P>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-3 d-flex">
                                    <i class="fa-regular fa-paper-plane mt-2 " style="font-size: 27px;color: #fb8e26;"></i>
                                    <div>
                                        <p style="font-weight: 500;padding: 0px 10px 0px 10px;">Tour Type</p>
                                        <P class="text-slate-600"
                                            style="font-weight: 300;padding: 0px 10px 0px 10px;font-size:13px">
                                            {{ $singleTourPackage->tour_type }}</P>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-3 d-flex">
                                    <i class="fa-solid fa-people-group mt-2 " style="font-size: 27px;color: #fb8e26;"></i>
                                    <div>
                                        <p style="font-weight: 500;padding: 0px 10px 0px 10px;">Group Size</p>
                                        <P class="text-slate-600"
                                            style="font-weight: 300;padding: 0px 10px 0px 10px;font-size:13px">
                                            {{ $singleTourPackage->group_size }}</P>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-3 d-flex">
                                    <i class="fa-solid fa-language mt-2 " style="font-size: 27px;color: #fb8e26;"></i>
                                    <div>
                                        <p style="font-weight: 500;padding: 0px 10px 0px 10px;">Language</p>
                                        <P class="text-slate-600"
                                            style="font-weight: 300;padding: 0px 10px 0px 10px;font-size:13px">
                                            {{ $singleTourPackage->language }}</P>
                                    </div>
                                </div>
                            </div>

                            <div class="package-description mt-5">
                                <h5 class="mb-3">Overview</h5>
                                <p class="text-slate-600" style="font-weight:300!important">
                                    {{ $singleTourPackage->overview }}</p><br>
                                <div class="text-slate-600" style="font-weight:300!important">{!! $singleTourPackage->long_description !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-9 col-12 booking-form">
                    <h5>Booking form</h5>
                    <div class="aboutImg position-relative mt-md-0 mt-5 aos-init aos-animate" data-aos="fade-up">
                        <form method="post" action="{{route('booking')}}">
                            @csrf
                            <div class="mb-3">
                                <label for="exampleInputName" class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" placeholder="Your Full Name" required>
                            </div>
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label">Email</label>
                                <input type="email" class="form-control" name="email" placeholder="A valid Email" required>
                            </div>
                            <div class="mb-3">
                                <label for="exampleInputPassword1" class="form-label">Phone</label>
                                <input type="tel" class="form-control" name="phone" placeholder="Phone No" required>
                            </div>
                            <div>
                                <label for="exampleInputPassword1" class="form-label">Destination</label><br>
                                <select class="single_package" class="mb-3" name="destination" id="destination"
                                    style="width:100%;border:none;  padding: .375rem .75rem;border: 1px solid #ced4da;" required>
                                    <option value="" selected disabled>Destination</option>
                                    @foreach ($destination as $item )

                                    <option value="{{$item->title}}">{{$item->title}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="adult" class="form-label">Adult</label>
                                    <input type="number" class="form-control" name="adult" id="adult" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="child" class="form-label">Child</label>
                                    <input type="number" class="form-control" name="child" id="child" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="adult" class="form-label">Start Date</label>
                                    <input type="date" class="form-control" name="start_date" id="adult" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="child" class="form-label">End Date</label>
                                    <input type="date" class="form-control" name="end_date" id="child" required>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-floating">
                                    <textarea class="form-control mb-2" placeholder="Address" name="address" required></textarea>
                                    <label for="floatingTextarea2" style="color: #dadbdd;" >Address</label>
                                </div>
                                <div class="form-floating">
                                    <textarea class="form-control" name="message" required placeholder="Leave a comment here" id="floatingTextarea2" style="height: 100px"></textarea>
                                    <label for="floatingTextarea2" style="color: #dadbdd;">Tell Us Anything</label>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary mb-3"
                                style="width: 100%;background: #fb8e26;border: 1px solid #fb8e26;">Book
                                Now<span></span><span></span><span></span><span></span>
                                <i class="fa-solid fa-arrow-right"></i></button>
                        </form>
                    </div>
                    @if ($singleTourPackage->map_url != null)
                    <div class="map">
                        <h6>Tour Map</h6>
                        <div class="mt-3 map-container">
                            <iframe src="{{ $singleTourPackage->map_url }}" class="map-frame"
                                allowfullscreen=""></iframe>
                        </div>
                    </div>
                    @endif


                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.4 about section ====== -->
@endsection
