@extends('layouts.web_master')

@section('header-content')
    <div class="header-destination" style="background: url({{asset($banner->tour_package_banner)}}); background-position: center !important;
    background-repeat: no-repeat !important;
    background-size: cover !important;">
        <!-- ====== 3.1 hero section ====== -->
        <section class="hero">
            <div class="container">
                <div class="row justify-content-center mt-5">
                    <div class="col-lg-11 col-md-12 text-center" data-aos="fade">
                        <div>
                            <h2>Tour & Packages</h2>
                            <div class="d-flex justify-content-center gap-4 pt-4">
                                <nav aria-label="breadcrumb">
                                    <div class="breadcrumb d-flex gap-4 align-items-center">
                                        <div class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></div>
                                        <i class="fa-solid fa-angles-right"></i>
                                        <div class="breadcrumb-item" aria-current="page">Tour & Packages</div>
                                    </div>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!-- ====== End 3.1 hero section ====== -->
@endsection
<style>
    .overlay {
        height: 347px !important;
    }
</style>
@section('main-content')
    <!-- ====== 1.14 about section ====== -->
    <section id="about" class="about">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-10" data-aos="fade-up">
                    {{-- <form method="post" action="{{route('booking')}}"
                        class="d-flex gap-lg-2 gap-md-1 gap-sm-4 gap-3 justify-content-evenly align-items-md-center">
                         @csrf
                        <div>
                            <h6>Name</h6>
                            <input type="text" name="name" placeholder="Your Name" required>
                        </div>
                        <div>
                            <h6>Destination</h6>
                                <select name="destination">
                                    <option value="" selected disabled>Destination</option>
                                    @foreach ($tourPackages as $item)
                                    <option value="{{$item->title}}">{{$item->title}}</option>
                                    @endforeach

                            </select>
                        </div>
                        <div>
                            <h6>Tour Days</h6>
                            <input type="date" name="start_date" required>
                        </div>
                        <div class="globalBtn">
                            <ul>
                                <li>
                                    <button type="submit">Book Now
                                        <span></span><span></span><span></span><span></span>
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </form> --}}
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.14 about section ====== -->

    <!-- ====== 1.6 tours section ====== -->
    <section id="tour" style="padding: 50px 0px">
        <div class="container">
            <div data-aos="fade" data-aos-duration="2000">
                <h4>Tour</h4>
                <h2>Live Your Life Through Travel</h2>
                <div class="d-flex flex-md-row flex-column gap-3 justify-content-between align-items-center mt-3">
                    <div class="tourPara">

                    </div>
                </div>
            </div>
            <div class="tourCards card-text mt-5">
                <div class="row gap-4 ">
                    @foreach ($tourPackages as $key=>$item)


                    <div class="col-md-4 col-sm-5 col-11" data-aos="fade-up" data-aos-delay="{{ 100 + ($key * 100)}}">
                        <div>
                            <figure><img src="{{asset($item->image_one)}}" alt="tour-img"></figure>
                            <h6>{{ $item->title}}</h6>
                            <div style="padding: 10px 30px 20px 30px !important">{{ Str::limit($item->overview, 80, '...') }}</div>
                            <a href="{{route('singleTourPackage',$item->id)}}">Learn More <i class="fa-solid fa-arrow-right"></i></a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.6 tours section ====== -->

    <!-- ====== 1.14 start planning section ====== -->
    <section id="planning">
        <div class="planningContent" data-aos="fade" data-aos-duration="2000">
            <h3>Start Planning Your Trip Now and <span>Get {{$offer->discount_one}} Discount</span></h3>
            <p>{{ $offer->short_description_one}}</p>
            <div class="globalBtn mt-lg-4 mt-3">
                <ul>
                    <li>
                        <a href="{{route('contact')}}">Book Now
                            <span></span><span></span><span></span><span></span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </section>
    <!-- ====== End 1.14 start planning section ====== -->
@endsection
