<?php

use App\Http\Controllers\Admin\AboutController;
use App\Http\Controllers\Admin\CompanyProfileController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\OfferController;
use App\Http\Controllers\Admin\ServiceController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\SpecialityController;
use App\Http\Controllers\Admin\TeamController;
use App\Http\Controllers\Admin\TestmonialsController;
use App\Http\Controllers\Admin\TourPackageController;
use App\Http\Controllers\Admin\VideoController;
use App\Http\Controllers\AuthenticationController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\TourPackageSpotController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
|   website Route
|--------------------------------------------------------------------------
 */

Route::get('/', [HomeController::class, 'home'])->name('home');
Route::get('/pages/about', [HomeController::class, 'about'])->name('about');
Route::get('/pages/contact', [HomeController::class, 'contact'])->name('contact');
Route::get('/pages/service', [HomeController::class, 'service'])->name('service');
Route::get('/pages/tour/packages', [HomeController::class, 'tourPackages'])->name('tourPackages');
Route::get('/pages/tour/packages/{id}', [HomeController::class, 'singleTourPackage'])->name('singleTourPackage');
Route::get('/pages/tour/spot/packages', [HomeController::class, 'tourPackagesSpot'])->name('tourPackagesSpot');
Route::get('/pages/tour/spot/packages/{slug}', [HomeController::class, 'singleTourPackageSpot'])->name('singleTourPackageSpot');
Route::post('/tour/booking', [BookingController::class, 'booking'])->name('booking');
Route::post('/pages/newsletter', [BookingController::class, 'newsletter'])->name('newsletter');
Route::get('/pages/gallery', [HomeController::class, 'gallery'])->name('gallery');
Route::get('/pages/blog', [HomeController::class, 'blog'])->name('blog');
Route::get('/pages/singleblog/{slug}', [HomeController::class, 'singleblog'])->name('singleblog');


/*
|--------------------------------------------------------------------------
|    website Route End =================================================
|--------------------------------------------------------------------------
 */

/*
|--------------------------------------------------------------------------
|   Admin panel login Route
|--------------------------------------------------------------------------
 */
Route::group(['middleware' => 'guest'], function () {
    Route::get('/login', [AuthenticationController::class, 'login'])->name('login');
    Route::post('/login', [AuthenticationController::class, 'authCheck'])->name('login.check');
});

/*
|--------------------------------------------------------------------------
|   Admin panel login End =================================================
|--------------------------------------------------------------------------
 */

/*
|--------------------------------------------------------------------------
|   Admin Dashboard route
|--------------------------------------------------------------------------
 */

Route::group(['middleware' => 'adminAuth'], function () {

    //  Admin Account route
    Route::get('/dashboard', [DashboardController::class, 'dashboard'])->name('dashboard');
    Route::get('/registration', [AuthenticationController::class, 'registration'])->name('admin.registration');
    Route::post('/registration', [AuthenticationController::class, 'newUser'])->name('registration.store');
    Route::get('/user/edit/{id}', [AuthenticationController::class, 'userEdit'])->name('admin.user.edit');
    Route::post('/user/update/{id}', [AuthenticationController::class, 'userUpdate'])->name('admin.user.update');
    Route::post('/user/delete', [AuthenticationController::class, 'userDelete'])->name('admin.user.delete');
    Route::put('/password', [AuthenticationController::class, 'passwordUpdate'])->name('password.change');
    Route::get('/profile', [AuthenticationController::class, 'profile'])->name('profile');
    Route::post('/profile', [AuthenticationController::class, 'profileUpdate'])->name('profile.update');
    Route::get('/logout', [AuthenticationController::class, 'logout'])->name('admin.logout');

    // company profile route
    Route::get('/company-profile', [CompanyProfileController::class, 'index'])->name('company.index');
    Route::post('/company-profile/update', [CompanyProfileController::class, 'update'])->name('company_update');

    // about us route
    Route::get('/about-us', [AboutController::class, 'index'])->name('about.index');
    Route::post('/about-us/update', [AboutController::class, 'update'])->name('about.update');

    // about us route
    Route::get('/offer', [OfferController::class, 'index'])->name('offer.index');
    Route::post('/offer/update', [OfferController::class, 'update'])->name('offer.update');

    // slider route
    Route::get('/slider', [SliderController::class, 'index'])->name('slider.index');
    Route::post('/slider/store', [SliderController::class, 'store'])->name('slider.store');
    Route::get('/slider/edit/{id}', [SliderController::class, 'edit'])->name('slider.edit');
    Route::post('/slider/update/{id}', [SliderController::class, 'update'])->name('slider.update');
    Route::get('/slider/delete/{id}', [SliderController::class, 'delete'])->name('slider.delete');

    // service heading  route
    Route::get('/slider-heading', [SliderController::class, 'sliderHeading'])->name('sliderHeading');
    Route::post('/slider-heading/update', [SliderController::class, 'sliderHeadingUpdate'])->name('sliderHeading.update');

    // speciality route
    Route::get('/speciality', [SpecialityController::class, 'index'])->name('speciality.index');
    Route::post('/speciality/store', [SpecialityController::class, 'store'])->name('speciality.store');
    Route::get('/speciality/edit/{id}', [SpecialityController::class, 'edit'])->name('speciality.edit');
    Route::post('/speciality/update/{id}', [SpecialityController::class, 'update'])->name('speciality.update');
    Route::get('/speciality/delete/{id}', [SpecialityController::class, 'delete'])->name('speciality.delete');


    // gallery route
    Route::get('/gallery', [GalleryController::class, 'index'])->name('gallery.index');
    Route::post('/gallery/store', [GalleryController::class, 'store'])->name('gallery.store');
    Route::get('/gallery/edit/{id}', [GalleryController::class, 'edit'])->name('gallery.edit');
    Route::post('/gallery/update/{id}', [GalleryController::class, 'update'])->name('gallery.update');
    Route::get('/gallery/delete/{id}', [GalleryController::class, 'delete'])->name('gallery.delete');

    // video route
    Route::get('/gallery/video', [GalleryController::class, 'videoIndex'])->name('videos');
    Route::post('/gallery/video/store', [GalleryController::class, 'videoStore'])->name('video.store');
    Route::get('/gallery/video/{id}', [GalleryController::class, 'videoEdit'])->name('video.edit');
    Route::post('/gallery/video/update/{id}', [GalleryController::class, 'videoUpdate'])->name('videos.update');
    Route::get('/gallery/video/delete/{id}', [GalleryController::class, 'videoDelete'])->name('video.delete');

    // Blog route
    Route::get('/blog', [BlogController::class, 'index'])->name('blog.index');
    Route::post('/blog/store', [BlogController::class, 'store'])->name('blog.store');
    Route::get('/blog/edit/{id}', [BlogController::class, 'edit'])->name('blog.edit');
    Route::post('/blog/update/{id}', [BlogController::class, 'update'])->name('blog.update');
    Route::get('/blog/delete/{id}', [BlogController::class, 'delete'])->name('blog.delete');

    // service route
    Route::get('/service', [ServiceController::class, 'index'])->name('service.index');
    Route::post('/service/store', [ServiceController::class, 'store'])->name('service.store');
    Route::get('/service/edit/{id}', [ServiceController::class, 'edit'])->name('service.edit');
    Route::post('/service/update/{id}', [ServiceController::class, 'update'])->name('service.update');
    Route::get('/service/delete/{id}', [ServiceController::class, 'delete'])->name('service.delete');

    // service heading  route
    Route::get('/service-heading', [ServiceController::class, 'serviceHeading'])->name('serviceHeading');
    Route::post('/service-heading/update', [ServiceController::class, 'serviceHeadingUpdate'])->name('serviceHeading.update');

    // team route
    Route::get('/team', [TeamController::class, 'index'])->name('team.index');
    Route::post('/team/store', [TeamController::class, 'store'])->name('team.store');
    Route::get('/team/edit/{id}', [TeamController::class, 'edit'])->name('team.edit');
    Route::post('/team/update/{id}', [TeamController::class, 'update'])->name('team.update');
    Route::get('/team/delete/{id}', [TeamController::class, 'delete'])->name('team.delete');

    // Faq route
    Route::get('/faq', [FaqController::class, 'index'])->name('faq.index');
    Route::post('/faq/store', [FaqController::class, 'store'])->name('faq.store');
    Route::get('/faq/edit/{id}', [FaqController::class, 'edit'])->name('faq.edit');
    Route::post('/faq/update/{id}', [FaqController::class, 'update'])->name('faq.update');
    Route::get('/faq/delete/{id}', [FaqController::class, 'delete'])->name('faq.delete');

    // tesmonials route
    Route::get('/testimonials', [TestmonialsController::class, 'index'])->name('testimonials.index');
    Route::post('/testimonials/store', [TestmonialsController::class, 'store'])->name('testimonials.store');
    Route::get('/testimonials/edit/{id}', [TestmonialsController::class, 'edit'])->name('testimonials.edit');
    Route::post('/testimonials/update/{id}', [TestmonialsController::class, 'update'])->name('testimonials.update');
    Route::get('/testimonials/delete/{id}', [TestmonialsController::class, 'delete'])->name('testimonials.delete');

    // video route
    Route::get('/video', [VideoController::class, 'index'])->name('video.index');
    Route::post('/video/update', [VideoController::class, 'update'])->name('video.update');

    // Tour & packages route
    Route::get('/tour/packages', [TourPackageController::class, 'index'])->name('tourPackage.index');
    Route::post('/tour/packages/store', [TourPackageController::class, 'store'])->name('tourPackage.store');
    Route::get('/tour/packagess/edit/{id}', [TourPackageController::class, 'edit'])->name('tourPackage.edit');
    Route::post('/tour/packages/update/{id}', [TourPackageController::class, 'update'])->name('tourPackage.update');
    Route::get('/tour/packages/delete/{id}', [TourPackageController::class, 'delete'])->name('tourPackage.delete');

    // Tour & packages spt route
    Route::get('/tour/packages/spot', [TourPackageSpotController::class, 'index'])->name('tourPackageSpot.index');
    Route::post('/tour/packages/spot/store', [TourPackageSpotController::class, 'store'])->name('tourPackageSpot.store');
    Route::get('/tour/packagess/spot/edit/{id}', [TourPackageSpotController::class, 'edit'])->name('tourPackageSpot.edit');
    Route::post('/tour/packages/spot/update/{id}', [TourPackageSpotController::class, 'update'])->name('tourPackageSpot.update');
    Route::get('/tour/packages/spot/delete/{id}', [TourPackageSpotController::class, 'delete'])->name('tourPackageSpot.delete');

    // banner route
    Route::get('/banner', [BannerController::class, 'index'])->name('banner.index');
    Route::post('/banner/update', [BannerController::class, 'update'])->name('banner.update');

    // Booking route
    Route::get('/booking/list', [BookingController::class, 'bookingList'])->name('bookingList');
    Route::get('/booking/list/delete/{id}', [BookingController::class, 'delete'])->name('booking.delete');

    // news letter route
    Route::get('/newsletter/list', [BookingController::class, 'newsLetterList'])->name('newsLetterList');
    Route::get('/newsletter/list/delete/{id}', [BookingController::class, 'newLetterdelete'])->name('newsletter.delete');
});



/*
|--------------------------------------------------------------------------
|   Admin Dashboard route End =============================================
|--------------------------------------------------------------------------
 */
