<?php $__env->startSection('title', 'Gallery Update'); ?>
<?php $__env->startSection('main-content'); ?>
    <main>
        <div class="container-fluid" id="Category">
            <div class="heading-title p-2 my-2">
                <span class="my-3 heading "><i class="fas fa-home"></i> <a class="" href="">Home</a> >
                    Gallery Update</span>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head">
                                <i class="fab fa-bandcamp"></i> Gallery Update
                            </div>
                        </div>

                        <div class="card-body table-card-body">
                            <form method="post" action="<?php echo e(route('gallery.update',$gallery->id)); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-group row">
                                    <label for="title" class="col-sm-3 col-form-label">Title <span
                                            style="color: red">*</span></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="title" placeholder="Title" value="<?php echo e($gallery->title); ?>"
                                            class="form-control form-control-sm shadow-none" >
                                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span style="color: red"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Image <span
                                            style="color: red">*</span> (<small class="text-danger">550 x 480 px</small>)
                                    </label>
                                    <div class="col-sm-9">
                                        <input type="file" name="image" class="form-control shadow-none" id="image"
                                             onchange="mainThambUrl(this)">
                                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span style="color: red"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div>
                                            <img src="<?php echo e(asset($gallery->image)); ?>" id="mainThmb"
                                                style="width: 100px; height: 100px; border: 1px solid #999; padding: 2px;"
                                                alt="">
                                        </div>
                                    </div>
                                </div>
                                <hr class="my-2">
                                <div class="clearfix">
                                    <div class="text-end m-auto">
                                        <button type="reset" class="btn btn-danger shadow-none">Reset</button>
                                        <button type="submit" class="btn btn-success shadow-none">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="card my-2">
                        <div class="card-header d-flex justify-content-between">
                            <div class="table-head"><i class="fas fa-table me-1"></i> Gallery List</div>
                            <div class="float-right">

                            </div>
                        </div>
                        <div class="card-body table-card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered text-center" id="datatablesSimple" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>SL</th>
                                            <th>Title</th>
                                            <th>Image</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="<?php echo e($item->id); ?>">
                                                <td><?php echo e($loop->index + 1); ?></td>
                                                <td><?php echo e($item->title); ?></td>
                                                <td><img src="<?php echo e(asset($item->image)); ?>" width="30" height="30"
                                                        alt=""></td>
                                                <td>
                                                    <a href="<?php echo e(route('gallery.edit', $item->id)); ?>" class="btn btn-edit"><i
                                                            class="fas fa-pencil-alt"></i></a>

                                                    <a href="<?php echo e(route('gallery.delete', $item->id)); ?>"
                                                        onclick="return confirm('Are You Sure?')" class="btn btn-delete"><i
                                                            class="fa fa-trash"></i></a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function mainThambUrl(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#mainThmb').attr('src', e.target.result).width(100)
                        .height(100);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pintusof/rupantor.pintusoft.com/resources/views/Admin/gallery/edit.blade.php ENDPATH**/ ?>