<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <title>Admin | Login</title>
    <link href="https://fonts.googleapis.com/css?family=Karla:400,700&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('backend_asset/css/materialdesignicons.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('back_asset/css/bootstrap-4.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('back_asset/css/login.css')); ?>" />
    <link href="<?php echo e(asset('back_asset/css/toastr.min.css')); ?>" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('back_asset/css/sweetalert.css')); ?>" />
</head>

<body>
    <main class="d-flex align-items-center min-vh-100 py-3 py-md-0">
        <div class="container">
            <div class="row">
                <div class="col-md-10 mx-auto">
                    <div class="card login-card">
                        <div class="row no-gutters">
                            <div class="col-md-6">
                                <img src="<?php echo e(asset('back_asset/images/login-otp-banner.webp')); ?>" alt="login"
                                    class="login-card-img" />
                            </div>
                            <div class="col-md-6">
                                <div class="card-body">

                                    <div class="brand-wrapper mb-3" style="text-align: center">
                                        <img src="<?php echo e($info->logo ? asset($info->logo) : asset('no.png')); ?>" alt="logo" class="logo" />

                                    </div>
                                    
                                    <?php if(session('error')): ?>
                                        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
                                    <?php endif; ?>

                                    <?php if(session('success')): ?>
                                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                                    <?php endif; ?>

                                    <?php echo $__env->yieldContent('main-content'); ?>
                                    <form action="<?php echo e(route('login.check')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <label for="email" class="sr-only">Username</label>
                                            <input type="text" name="username" id="username"
                                                class="form-control shadow-none <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                value="<?php echo e(old('username')); ?>" placeholder="username" />
                                            <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        </div>
                                        <div class="form-group mb-4">
                                            <label for="password" class="sr-only">Password</label>
                                            <input type="password" name="password" id="password"
                                                value="<?php echo e(old('password')); ?>"
                                                class="form-control shadow-none <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="Password" />
                                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <input type="submit" name="login" id="login"
                                            class="btn btn-block login-btn mb-4 shadow-none" value="Login" />
                                    </form>
                                    
                                    <nav class="login-card-footer-nav">
                                        <a href="#!">Copyright &copy; <?php echo e(date('Y')); ?></a>
                                        <a href="#!"></a>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <script src="<?php echo e(asset('js/jquery-3.4.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap-4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back_asset/js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('back_asset/js/sweetalert.js')); ?>" type="text/javascript"></script>
    <script>
        $("document").ready(function() {
            setTimeout(function() {
                $("div.alert").remove();
            }, 3000); // 5 secs
        });
    </script>
    <script>
        <?php if(Session::has('update')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("<?php echo e(session('update')); ?>");
        <?php endif; ?>

        <?php if(Session::has('message')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("<?php echo e(session('message')); ?>");
        <?php endif; ?>
        <?php if(Session::has('success')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("<?php echo e(session('success')); ?>");
        <?php endif; ?>


        <?php if(Session::has('error')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>
    </script>
</body>

</html>
<?php /**PATH /home/pintusof/rupantor.pintusoft.com/resources/views/auth/login.blade.php ENDPATH**/ ?>