<?php $__env->startSection('header-content'); ?>
    <!-- header slider start -->
    <div class="header-slider">
        <?php $__currentLoopData = $slider; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="slide active">
            <img src="<?php echo e(asset($item->image)); ?>" alt="slider-img">
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>
    <!-- header slider end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header-text'); ?>
    <!-- ====== 1.2 hero section ====== -->
    <section id="hero">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-11 col-md-12 text-center" data-aos="fade">
                    
                    <h1><?php echo e($sliderHeading->title); ?></h1>
                    <p><?php echo e($sliderHeading->short_description); ?>

                    </p>
                    <div class="globalBtn mt-4">
                        <ul>
                            <li>
                                <a href="<?php echo e(url('about')); ?>"> Discover Now
                                    <span></span><span></span><span></span><span></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.2 hero section ====== -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main-content'); ?>
    <!-- ====== 1.3 features section ====== -->
    <section id="features">
        <div class="container card-text">
            <div class="row">
                <?php $__currentLoopData = $speciality; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                <div class="col-md-3" data-aos="fade-up" data-aos-delay="<?php echo e(100 + ($key * 200)); ?>">
                    <div>
                        <figure><img src="<?php echo e(asset($item->icon)); ?>" alt="featureIcon"></figure>
                        <h6><?php echo e($item->title); ?></h6>
                        <p style="text-align: justify"><?php echo e(Str::limit($item->short_description, 100, '...')); ?>

                        </p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- ====== End 1.3 features section ====== -->

    <!-- ====== 1.4 about section ====== -->
    <section id="about">
        
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-md-9">
                    
                    <div class="col-lg-10 col-md-9" data-aos="fade-up">
                        <div>
                            <h4>About Us</h4>
                            <h2><?php echo e($about->title); ?></h2>
                            <div style="text-align: justify"><?php echo $about->details; ?></div>
                            <div class="globalBtnActive justify-content-md-start justify-content-center mt-4">
                                <ul>
                                    <li>
                                        <a href="<?php echo e(route('about')); ?>"> Learn More
                                            <span></span><span></span><span></span><span></span>
                                            <i class="fa-solid fa-arrow-right"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-9 col-12 about-Image">
                    <div class="aboutImg position-relative" data-aos="fade-up" style="margin-top:3rem">
                        <figure>
                            <img src="<?php echo e(asset($about->image)); ?>" alt="about-sec">
                        </figure>
                        <div class="customer d-flex flex-column justify-content-between align-items-center">
                            <div class="d-flex">
                                <h2 class="count"><?php echo e($about->no_of_client); ?> </h2>
                                <h2>+</h2>
                            </div>
                            <p>Happy Customers</p>
                        </div>
                        <div class="experience d-flex flex-column justify-content-between align-items-center"
                            data-aos="fade-up">
                            <div class="d-flex">
                                <h2 class="count"><?php echo e($about->year_of_experience); ?></h2>
                                <h2>+</h2>
                            </div>
                            <p>Years of experience</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.4 about section ====== -->

    <!-- ====== 1.5 special offer section ====== -->
    <section id="special">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6" data-aos="fade-down">
                    <h3><?php echo e($offer->title_one); ?> </h3>
                    <p><?php echo e(Str::limit($offer->short_description_one, 120, '...')); ?></p>
                    <div class="offer">
                        <img src="<?php echo e(asset($offer->image_one)); ?>" alt="discount">
                        <div class="overlaytwo">
                            <div class="overlay_text">
                                <h3>Discount up <?php echo e($offer->disscount_one); ?></h3>
                                <div class="globalBtn mt-lg-5 mt-4">
                                    <ul>
                                        <li>
                                            <a href="<?php echo e(route('contact')); ?>">Book Now
                                                <span></span><span></span><span></span><span></span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mt-md-0 mt-4" data-aos="fade-up">
                    <div class="offer">
                        <img src="<?php echo e(asset($offer->image_two)); ?>" alt="discount">
                        <div class="overlaytwo">
                            <div class="overlay_text">
                                <h3>Discount up <?php echo e($offer->discount_two); ?></h3>
                                <div class="globalBtn mt-lg-5 mt-4">
                                    <ul>
                                        <li>
                                            <a href="<?php echo e(url('contact')); ?>">Book Now
                                                <span></span><span></span><span></span><span></span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h3><?php echo e($offer->title_two); ?></h3>
                    <p><?php echo e(Str::limit($offer->short_description_two, 120, '...')); ?>.</p>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.5 special offer section ====== -->
    <!-- ====== 1.6 tours section ====== -->
    <section id="tour">
        <div class="container">
            <div data-aos="fade" data-aos-duration="2000">
                <h4>Tour & Packages</h4>
                <h2>Live Your Life Through Travel</h2>
                <div class="d-flex flex-md-row flex-column gap-3 justify-content-between align-items-center mt-3">
                    <div class="tourPara">
                        
                    </div>
                    <div class="globalBtnActive">
                        <ul>
                            <li>
                                <a href="<?php echo e(route('tourPackages')); ?>"> View all
                                    <span></span><span></span><span></span><span></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="tourCards card-text mt-5">
                <div class="row gap-4 ">
                    <?php $__currentLoopData = $tourPackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="col-md-4 col-sm-5 col-11" data-aos="fade-up" data-aos-delay="<?php echo e(100 + ($key * 200)); ?>">
                        <div>
                            <figure>
                                <img src="<?php echo e(asset($item->image_one)); ?>" alt="tour-img">
                            </figure>
                            <h6><?php echo e($item->title); ?></h6>
                            <p><?php echo e(Str::limit($item->overview, 80, '...')); ?></p>
                            <a href="<?php echo e(route('singleTourPackage',$item->id)); ?>">Learn More <i class="fa-solid fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.6 tours section ====== -->

    <!-- ====== 1.7 why choose us section ====== -->
    <section id="choose">
        <div class="chooseBg">
            <div class="position-relative z-2" data-aos="fade" data-aos-duration="2000">
                <h4>Why choose us</h4>
                <h2>Let Us Show You The Beauty
                    Of The World</h2>
                <div class="globalBtn mt-lg-5 mt-md-5">
                    <ul>
                        <li>
                            <a href="<?php echo e(route('contact')); ?>">contact us
                                <span></span><span></span><span></span><span></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="chooseCrads position-relative z-2">
            <div class="container">
                <div class="row gap-md-0 gap-4 justify-content-center card-text">
                    <?php $__currentLoopData = $speciality; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-4" data-aos="fade-up" data-aos-delay="<?php echo e(100 + ($key * 100)); ?>">
                        <div>
                            <figure>
                                <img src="<?php echo e(asset($item->icon)); ?>" alt="chooseIcon">
                            </figure>
                            <h6><?php echo e($item->title); ?></h6>
                            <p style="text-align: justify">
                                <?php echo e(Str::limit($item->short_description, 130, '...')); ?>

                            </p>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.7 why choose us section ====== -->

    <!-- ====== 1.8 services section ====== -->
    <section id="services">
        <div class="container">
            <div class="row">
                <div class="col-md-7">
                    <div data-aos="fade" data-aos-duration="2000">
                        <h4>Our Services</h4>
                        <h2><?php echo e($serviceHeading->title); ?></h2>
                        <p><?php echo e($serviceHeading->short_description); ?>

                        </p>
                        <div class="row align-items-center gap-lg-3 gap-md-4 text-lg-start text-center">
                            <?php $__currentLoopData = $service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-3">
                                <div>
                                    <figure>
                                        <img src="<?php echo e(asset($item->icon)); ?>" alt="servicesIcon">
                                    </figure>
                                <h6><?php echo e($item->title); ?></h6>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div
                            class="globalBtnActive d-flex justify-content-md-start justify-content-center mt-lg-3 mt-md-3 mt-4">
                            <ul>
                                <li>
                                    <a href="<?php echo e(route('service')); ?>">See all services
                                        <span></span><span></span><span></span><span></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5 mt-md-0 mt-5" data-aos="fade-up" data-aos-easing="ease-in-out-quad">
                    <div>
                        <figure>
                            <img src="<?php echo e(asset($serviceHeading->image_one)); ?>" alt="service-img">
                        </figure>
                        <figure>
                            <img src="<?php echo e(asset($serviceHeading->image_two)); ?>" alt="ser-Camera">
                        </figure>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.8 services section ====== -->

    <!-- ====== 1.9 what we do section ====== -->
    <section id="weDo">
        <div class="container">
            <div class="row">
                <div class="col-md-6 d-flex justify-content-center">
                    <div class="weDo-video">
                        <div>
                            <a class="video-play-button" href="<?php echo e($video->video_link); ?>" target="_blank">
                                <span class="fa-solid fa-play"></span>
                            </a>
                        </div>
                        <figure>
                            <img src="<?php echo e(asset('assets/images/index-wedo-img.webp')); ?>"  alt="weDo" style="height:679px">
                        </figure>
                    </div>
                </div>
                <div class="col-md-6 d-flex justify-content-center align-content-center">
                    <div class="weDo-content d-flex flex-column justify-content-center align-items-start">
                        <div data-aos="fade" data-aos-duration="2000">
                            <h2><?php echo e($video->title); ?></h2>
                            <p><?php echo e($video->short_description); ?></p>
                        </div>
                        <div class="globalBtnActive mt-3" data-aos="fade" data-aos-duration="2000">
                            <ul>
                                <li>
                                    <a href="<?php echo e(route('service')); ?>"> Learn More
                                        <span></span><span></span><span></span><span></span>
                                        <i class="fa-solid fa-arrow-right"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.9 what we do section ====== -->

    <!-- ====== 1.10 our team section ====== -->
    <section id="team">
        <div class="container">
            <div data-aos="fade" data-aos-duration="2000">
                <h4>Our Team</h4>
                <h2>Experience The World With Us</h2>
            </div>

            <div class="row justify-content-md-between justify-content-center gap-md-0 gap-4">

                <?php $__currentLoopData = $team; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div class=" col-md-4 col-sm-8 col-10" data-aos="fade-up" data-aos-delay="<?php echo e(100 + ($key * 200)); ?>">
                    <div class="teamCard">
                        <img src="<?php echo e(asset($item->image)); ?>" alt="teamimg">
                        <div class="overlaythree">
                            <div class="overlay_text">
                                <div class="d-flex justify-content-center gap-2">

                                    <a href="mailto:<?php echo e($item->email); ?>" target="_blank"><i class=" fa-regular fa-envelope"></i></a>
                                    <a href="tel:<?php echo e($item->phone); ?>" target="_blank"><i class="fa-solid fa-phone"></i></a>
                                    <a href="<?php echo e($item->facebook); ?>" target="_blank"><i class="fa-brands fa-facebook-f"></i></a>
                                    <a href="<?php echo e($item->twitter); ?>" target="_blank"><i class="fa-brands fa-twitter"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div>
                        <h6><?php echo e($item->name); ?></h6>
                        <p><?php echo e($item->designation); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </section>

    <!-- ====== End 1.10 our team section ====== -->

    <!-- ====== 1.11 faq section ====== -->
    <section id="faq">
        <div class="container">
            <div class="faq-section">
                <div data-aos="fade">
                    <h4>FAQ</h4>
                    <h2>Have Answers, Will Travel.</h2>
                </div>
                <div class="accordion" id="accordionExample" data-aos="fade">
                    <?php $__currentLoopData = $faq; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="accordion-item">
                        <h6 class="accordion-header" id="heading<?php echo e($key); ?>">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse<?php echo e($key); ?>" aria-expanded="false" aria-controls="collapse<?php echo e($key); ?>">
                                <?php echo e($item->title); ?>

                            </button>
                        </h6>
                        <div id="collapse<?php echo e($key); ?>" class="accordion-collapse collapse" aria-labelledby="heading<?php echo e($key); ?>"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <div><?php echo $item->details; ?></div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.11 faq section ====== -->

    <!-- ====== 1.12 testimonials section ====== -->
    <section id="testimonials">
        <div class="container">
            <div class="row card-text justify-content-md-between justify-content-center gap-md-0 gap-3">
                <div data-aos="fade" data-aos-duration="2000">
                    <h4>Testimonials</h4>
                    <h2>We're All About Your Satisfaction</h2>
                </div>
                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div class="col-md-4 col-sm-8 col-11" data-aos="fade-up" data-aos-delay="100">
                    <div class="d-flex flex-column align-items-center justify-content-center">
                        <figure>
                            <img src="<?php echo e(asset($item->image)); ?>" alt="testimonialsImg">
                        </figure>
                        <h6><?php echo e($item->name); ?></h6>
                        <p><?php echo e($item->designation); ?></p>
                        <div class="d-flex gap-2 mt-3 mb-4 pb-2">
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                        </div>
                        <p><?php echo e(Str::limit($item->short_description, 180, '...')); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- ====== End 1.12 testimonials section ====== -->

    <!-- ====== 1.14 start planning section ====== -->
    <section id="planning">
        <div class="planningContent" data-aos="fade" data-aos-duration="2000">
            <h3>Start Planning Your Trip Now and <span>Get <?php echo e($offer->discount_one); ?> Discount</span></h3>
            <p><?php echo e(Str::limit($offer->short_description_one, 120, '...')); ?></p>
            <div class="globalBtn mt-lg-4 mt-3">
                <ul>
                    <li>
                        <a href="<?php echo e(route('contact')); ?>">Book Now
                            <span></span><span></span><span></span><span></span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </section>
    <!-- ====== End 1.14 start planning section ====== -->

    <!-- ====== 1.16 newsletter section ====== -->
    <section id="newsletter">
        <div class="container">
            <div data-aos="fade" data-aos-duration="2000">
                <h4>Newsletter</h4>
                <h2>Stay In The Know, Without Having To Do Anything</h2>
            </div>
            <div class="row justify-content-between" data-aos="fade" data-aos-duration="2000">
                <div class="col-md-5">
                    <div>
                        <p>
                            You can email us for any inquiries and ask anything about our tours!
                        </p>
                    </div>
                </div>
                <div class="col-md-7">
                    <div class="d-md-flex justify-content-lg-end justify-content-md-end justify-content-center">
                        <form  method="post" action="<?php echo e(route('newsletter')); ?>">
                            <?php echo csrf_field(); ?>
                            <div id="newsletter-message"></div>
                            <input type="email" name="email"  placeholder="Enter Your Email Address"
                                required>
                            <div class="globalBtnActive">
                                <ul>
                                    <li>
                                        <button type="submit">Subscribe
                                            <span></span><span></span><span></span><span></span>
                                        </button>
                                    </li>
                                </ul>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ====== End 1.16 newsletter section ====== -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.web_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laragon\www\rupantor_eco_tourism\resources\views/pages/index.blade.php ENDPATH**/ ?>