<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rupantor Eco Tourism</title>
    <link rel="shortcut icon" href="<?php echo e(asset($info->logo)); ?>" type="image/x-icon">

    <!-- Framework CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap-lib-bootstrap.min.css')); ?>">
    <!-- Font Awesome / Icon Fonts -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/icon-font-awesome.min.css')); ?>">
    <!-- Style Theme -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/css-style.css')); ?>">
    <!-- Responsive Theme -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/css-responsive.css')); ?>">
    <!-- Slider -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/css-slick.min.css')); ?>">
    <!-- AOS Animation -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/css-aos.css')); ?>">
    <!-- Font Awesome CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css"
        integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- toaster -->
    <link href="<?php echo e(asset('back_asset/css/toastr.min.css')); ?>" rel="stylesheet" />

    <?php echo $__env->yieldPushContent('web-css'); ?>
</head>

<body>
    <!-- Site Wrapper -->
    <div class="site-wrapper">
        <!-- Header Slider Start -->
        <?php echo $__env->yieldContent('header-content'); ?>
        <div class="overlay">
            <div class="header-content">
                <!-- ====== 1.1 Header Section ====== -->
                <?php echo $__env->make('partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->yieldContent('header-text'); ?>
            </div>
        </div>

        <?php echo $__env->yieldContent('main-content'); ?>

        <?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <!-- Button Back to Top -->
    <button onclick="scrollToTop()" id="backToTopBtn" class="btn_hover2">
        <i class="fa-solid fa-arrow-turn-up"></i>
    </button>

    <!-- jQuery -->
    <script data-cfasync="false" src="<?php echo e(asset('assets/js/cloudflare-static-email-decode.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/js-jquery.js')); ?>"></script>
    <!-- Counter -->
    <script src="<?php echo e(asset('assets/js/js-waypoints.min.js')); ?>"></script>
    <!-- Framework JavaScript -->
    <script src="<?php echo e(asset('assets/js/javascript-lib-bootstrap.min.js')); ?>"></script>
    <!-- Slider -->
    <script src="<?php echo e(asset('assets/js/js-slick.min.js')); ?>"></script>
    <!-- Custom JavaScript -->
    <script src="<?php echo e(asset('assets/js/js-custom.js')); ?>"></script>
    <!-- AOS Animation -->
    <script src="<?php echo e(asset('assets/js/js-aos.js')); ?>"></script>
    <!-- toaster-->
    <script src="<?php echo e(asset('back_asset/js/toastr.min.js')); ?>"></script>

    <script>
        // AOS Animation Start
        AOS.init({
            once: true,
            duration: 1000
        });
        // AOS Animation End

        // Header Slider
        const slides = document.querySelectorAll('.slide');
        let currentSlide = 0;

        function changeSlide() {
            slides[currentSlide].classList.remove('active');
            currentSlide = (currentSlide + 1) % slides.length;
            slides[currentSlide].classList.add('active');
        };
        setInterval(changeSlide, 5000);
    </script>

    <script>
        (function() {
            function c() {
                var b = a.contentDocument || a.contentWindow.document;
                if (b) {
                    var d = b.createElement('script');
                    d.innerHTML =
                        "window.__CF$cv$params={r:'8d5ff5551fcf7676',t:'MTcyOTUwMDE4OS4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";
                    b.getElementsByTagName('head')[0].appendChild(d);
                }
            }
            if (document.body) {
                var a = document.createElement('iframe');
                a.height = 1;
                a.width = 1;
                a.style.position = 'absolute';
                a.style.top = 0;
                a.style.left = 0;
                a.style.border = 'none';
                a.style.visibility = 'hidden';
                document.body.appendChild(a);
                if ('loading' !== document.readyState) c();
                else if (window.addEventListener) document.addEventListener('DOMContentLoaded', c);
                else {
                    var e = document.onreadystatechange || function() {};
                    document.onreadystatechange = function(b) {
                        e(b);
                        'loading' !== document.readyState && (document.onreadystatechange = e, c());
                    };
                }
            }
        })();
    </script>

    <script>
        <?php if(Session::has('update')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("<?php echo e(session('update')); ?>");
        <?php endif; ?>

        <?php if(Session::has('message')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("<?php echo e(session('message')); ?>");
        <?php endif; ?>
        <?php if(Session::has('success')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.success("<?php echo e(session('success')); ?>");
        <?php endif; ?>


        <?php if(Session::has('error')): ?>
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            }
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>
    </script>
</body>

</html>
<?php /**PATH E:\laragon\www\rupantor_eco_tourism\resources\views/layouts/web_master.blade.php ENDPATH**/ ?>