<?php
/**
 * Single Spot template file.
 *
 * @package Tour
 */

get_header(); ?>

   <section class="breadcrumb-bg">
       <div class="container mt-2">
           <div class="row">
               <!-- breadcrumb -->
               <div class="breadcrumb-wrap">
                   <nav aria-label="breadcrumb">
                       <?php get_breadcrumb(); ?>
                   </nav>
               </div>
           </div>
       </div>
   </section>

    <section class="section custom-spot" id="spot">
        <div class="container-fluid">
        <?php if ( have_posts() ) : while( have_posts()  ) : the_post(); ?>
            <div class="row">
                <div class="col-md-3">
                    <div class="row">
                        <div class="col-me-6">
                        <?php 
                        $image = get_field('left_side_image-1');
                        if( !empty( $image ) ): ?>
                            <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                        <?php endif; ?>
                        </div> 
                        <div class="col-me-6">
                        <?php 
                        $image = get_field('left_side_image-2');
                        if( !empty( $image ) ): ?>
                            <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                        <?php endif; ?>
                        </div>    
                    </div>    
                </div>
                <div class="col-md-6">
                        <div class="row">
                        <?php 
                        $image = get_field('center_images');
                        if( !empty( $image ) ): ?>
                            <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                        <?php endif; ?>
                        </div>    
                </div>
                <div class="col-md-3">
                <div class="row">
                        <div class="col-me-6">
                        <?php 
                        $image = get_field('right_side_images-1');
                        if( !empty( $image ) ): ?>
                            <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                        <?php endif; ?>
                        </div> 
                        <div class="col-me-6">
                        <?php 
                            $image = get_field('right_side_images-2');
                            if( !empty( $image ) ): ?>
                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                            <?php endif; ?>
                    
                        </div>    
                    </div> 
                </div>
            </div>  
               <?php endwhile; 
        endif; ?> 
        </div>
        <div class="container">
            <div class="row">
            <?php if ( have_posts() ) : while( have_posts()  ) : the_post(); ?>
                <div class="col-md-12">
                    <div class="elementor-widget-container">
                            <div class="hfe-page-title pt-2 pb-2">
                                <a href="<?php the_permalink(); ?>">
                                    <h2 class="elementor-heading-title"><?php the_title(); ?></h2>
                                </a>   
                            </div>    
                    </div>    

                </div> 
                <?php endwhile; 
        endif; ?>      
            </div>    
        </div>  
        <div class="container">
            <div class="row">
            <?php if ( have_posts() ) : while( have_posts()  ) : the_post(); ?>
                <div class="col-md-8">
                    <div class="elementor-widget-inner">
                        <div class="lementor-widget-text">
                        <?php the_content(); ?>
                         </div>    
                    </div>    

                </div>
                <?php endwhile; 
        endif; ?>  
                <div class="col-md-4">
                    <div class="bootnews_custompost-2">
                        <div class="block-title-13"><h4 class="h5 title-box-dot"><span>Popular Spots</span></h4><div class="dot-line"></div></div>
                        <div class="small-post">
                            <!--post list-->
                        <?php
                        query_posts('post_type=spot&post_status=publish&posts_per_page=6&order=ASC&paged='. get_query_var('post'));
                        if(have_posts()) :
                            while(have_posts()) : the_post();
                                ?>
                            <article class="card card-full hover-a mb-4">
                                <div class="row">
                                    <div class="col-3 col-md-4 pe-2 pe-md-0">
                                        <!--thumbnail-->
                                        <div class="ratio_110-77 image-wrapper">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php if (has_post_thumbnail())
                                                    $imageUrl =  wp_get_attachment_image_src(get_post_thumbnail_id(),'full');?>
                                                <img alt="Post Thumbnail" src="<?php echo esc_url($imageUrl[0]); ?>">
 										<!-- post type -->
                                            </a>
                                        </div>
                                    </div>

                                    <div class="col-9 col-md-8">
                                        <div class="card-body pt-0">
                                            <!--title-->
                                            <h3 class="card-title h6 h5-sm h6-md">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?> </a>
                                                <?php the_excerpt(5); ?>
                                            </h3>
                                            <!--date-->

                                        </div>
                                    </div>
                                </div>
                            </article>
                            <!--End post list-->
                            <?php endwhile;
                        endif; ?>
                        </div>
                    </div>
                    <div class="banner2-card mb-5">
                        <img src="https://demo-egenslab.b-cdn.net/html/triprex/preview/assets/img/innerpage/support-img.jpg" alt="">
                        <div class="banner2-content-wrap">
                            <div class="banner2-content">
                                <div class="hotline-area">
                                    <div class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28">
                                            <path d="M27.2653 21.5995L21.598 17.8201C20.8788 17.3443 19.9147 17.5009 19.383 18.1798L17.7322 20.3024C17.6296 20.4377 17.4816 20.5314 17.3154 20.5664C17.1492 20.6014 16.9759 20.5752 16.8275 20.4928L16.5134 20.3196C15.4725 19.7522 14.1772 19.0458 11.5675 16.4352C8.95784 13.8246 8.25001 12.5284 7.6826 11.4893L7.51042 11.1753C7.42683 11.0269 7.39968 10.8532 7.43398 10.6864C7.46827 10.5195 7.56169 10.3707 7.69704 10.2673L9.81816 8.61693C10.4968 8.08517 10.6536 7.1214 10.1784 6.40198L6.39895 0.734676C5.91192 0.00208106 4.9348 -0.21784 4.18082 0.235398L1.81096 1.65898C1.06634 2.09672 0.520053 2.80571 0.286612 3.63733C-0.56677 6.74673 0.0752209 12.1131 7.98033 20.0191C14.2687 26.307 18.9501 27.9979 22.1677 27.9979C22.9083 28.0011 23.6459 27.9048 24.3608 27.7115C25.1925 27.4783 25.9016 26.932 26.3391 26.1871L27.7641 23.8187C28.218 23.0645 27.9982 22.0868 27.2653 21.5995ZM26.9601 23.3399L25.5384 25.7098C25.2242 26.2474 24.7142 26.6427 24.1152 26.8128C21.2447 27.6009 16.2298 26.9482 8.64053 19.3589C1.0513 11.7697 0.398595 6.75515 1.18669 3.88421C1.35709 3.28446 1.75283 2.77385 2.2911 2.45921L4.66096 1.03749C4.98811 0.840645 5.41221 0.93606 5.62354 1.25397L7.67659 4.3363L9.39976 6.92078C9.60612 7.23283 9.53831 7.65108 9.24392 7.88199L7.1223 9.53232C6.47665 10.026 6.29227 10.9193 6.68979 11.6283L6.85826 11.9344C7.45459 13.0281 8.19599 14.3887 10.9027 17.095C13.6095 19.8012 14.9696 20.5427 16.0628 21.139L16.3694 21.3079C17.0783 21.7053 17.9716 21.521 18.4653 20.8753L20.1157 18.7537C20.3466 18.4595 20.7647 18.3918 21.0769 18.5979L26.7437 22.3773C27.0618 22.5885 27.1572 23.0128 26.9601 23.3399ZM15.8658 4.66809C20.2446 4.67296 23.7931 8.22149 23.798 12.6003C23.798 12.858 24.0069 13.0669 24.2646 13.0669C24.5223 13.0669 24.7312 12.858 24.7312 12.6003C24.7257 7.7063 20.7598 3.74029 15.8658 3.73494C15.6081 3.73494 15.3992 3.94381 15.3992 4.20151C15.3992 4.45922 15.6081 4.66809 15.8658 4.66809Z"></path>
                                            <path d="M15.865 7.46746C18.6983 7.4708 20.9943 9.76678 20.9976 12.6001C20.9976 12.7238 21.0468 12.8425 21.1343 12.93C21.2218 13.0175 21.3404 13.0666 21.4642 13.0666C21.5879 13.0666 21.7066 13.0175 21.7941 12.93C21.8816 12.8425 21.9308 12.7238 21.9308 12.6001C21.9269 9.2516 19.2134 6.53813 15.865 6.5343C15.6073 6.5343 15.3984 6.74318 15.3984 7.00088C15.3984 7.25859 15.6073 7.46746 15.865 7.46746Z"></path>
                                            <path d="M15.865 10.267C17.1528 10.2686 18.1964 11.3122 18.198 12.6C18.198 12.7238 18.2472 12.8424 18.3347 12.9299C18.4222 13.0174 18.5409 13.0666 18.6646 13.0666C18.7883 13.0666 18.907 13.0174 18.9945 12.9299C19.082 12.8424 19.1312 12.7238 19.1312 12.6C19.1291 10.797 17.668 9.33589 15.865 9.33386C15.6073 9.33386 15.3984 9.54274 15.3984 9.80044C15.3984 10.0581 15.6073 10.267 15.865 10.267Z"></path>
                                        </svg>
                                    </div>
                                    <div class="content">
                                        <span>To More Inquiry</span>
                                        <h6><a href="tel:+990737621432">+990-737 621 432</a></h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>       
            </div>    
        </div>        
    </section>   

<?php get_footer(); ?>