<?php
/* Template Name: Tours & Packages */

get_header(); ?>
<section class="breadcrumb-bg">
    <div class="container mt-2">
        <div class="row">
            <!-- breadcrumb -->
            <div class="breadcrumb-wrap">
                <nav aria-label="breadcrumb">
                    <?php get_breadcrumb(); ?>
                </nav>
            </div>
        </div>
    </div>
</section>
<div class='container-fluid mt-5'>
    <div class='row cards'>
        <?php
        query_posts('post_type=tour&post_status=publish&posts_per_page=6&order=ASC&paged='. get_query_var('post'));
        if(have_posts()) :
            while(have_posts()) : the_post();
                ?>
                <div class='card-single card-offshore col-md-12 col-lg-6'>
                    <div class='row'>

                        <div class='col-xs-12 col-sm-6 card-img offshore-img2'>
                            <img class="card-img-top" src="<?php echo get_the_post_thumbnail_url(); ?>" />
                        </div>
                        <div class='col-xs-12 col-sm-6 card-content'>
                            <div class='card-height d-flex align-items-center justify-content-center'>
                                <div class='card-text'>
                                    <h2><?php the_title(); ?></h2>
                                    <p>Offshore six to eight hour tours are available. These trips can consist of trolling for mahi, sailfish, kingfish, & Wahoo.</p>
                                    <p>We also offer offshore bottom fishing trips for grouper, snapper, seabass, cobia, and flounder.</p>
                                    <a class="custom-button" href="<?php the_permalink(); ?>">BOOK NOW</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile;
        endif; ?>
    </div>
</div>

<?php get_footer(); ?>
