<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0">
    <!-- Favicon-->
    <?php if ( get_theme_mod( 'themeslug_logo' ) ) : ?>
        <link rel="shortcut icon" href="<?php echo esc_url( get_theme_mod( 'themeslug_favicon' ) ); ?>" />
    <?php endif; ?>
    <title><?php bloginfo( 'name' ); ?></title>
    <!------ Include the above in your HEAD tag ---------->

    <?php wp_head() ?>
</head>

<body <?php body_class(); ?>>
  <!-- all your content here --> 
  <h1 class="text-lg">Back to top</h1>
<header>
    <nav class="navbar navbar-expand-lg navbar-light shadow-sm bg-white fixed-top">
        <div class="container">
            <!--     <a class= href="#">
                     <img src="http://example3.com/wp-content/uploads/2024/01/logo-1.png" class="img-fluid" alt="logo">
                 </a>-->
            <a class="navbar-brand d-flex align-items-center" href="<?php echo home_url(); ?>">
                <!-- Logo Image -->
                <img src="<?php echo get_theme_mod('tour_logo');?>" alt="Logo" class="d-inline-block align-middle mr-2">
                <!-- Logo Text -->
            </a>
            <button class="navbar-toggler navbar-toggler-right border-0" type="button" data-toggle="collapse" data-target="#navbar4">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbar4">
                <ul class="navbar-nav ml-auto pr-4">
                    <li class="nav-item px-md-2 active"> <a class="nav-link" href="features.php">Home</a></li>
                    <li class="nav-item dropdown">

                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Tours & Packages
                        </a>
                        <div class="dropdown-menu shadow-sm sm-menu" aria-labelledby="dropdown01">
                            <a class="dropdown-item" href="#">Community Connect</a>
                            <a class="dropdown-item" href="#">Wildlife Wonders</a>
                            <a class="dropdown-item" href="#">Jungle Adventures</a>
                            <a class="dropdown-item" href="#">Heritage Exploration</a>
                            <a class="dropdown-item" href="#">Educate & Explore</a>
                        </div>
                    </li>
                    <li class="nav-item px-md-2"> <a class="nav-link" href="#">About Us</a> </li>
                    <li class="nav-item px-md-2"> <a class="nav-link" href="#">Gallery</a> </li>
                    <li class="nav-item px-md-2"> <a class="nav-link" href="#">Blog/News</a> </li>
                    <li class="nav-item px-md-2"> <a class="nav-link" href="#">Contact Us</a> </li>
                </ul>
                <a class="text-dark pl-4 d-none d-lg-inline-block border-left text-decoration-none" href="tel:8879094014"><i class="fa-solid fa-phone"></i>+8801711829414</a>
            </div>
        </div>
    </nav>
    <!--The html below this line is for display purpose only-->
</header>